/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.network.packet;

import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.core.network.diagnostics.NetworkDataClient;
import org.cyclops.integrateddynamics.core.network.diagnostics.NetworkDiagnosticsPartOverlayRenderer;
import org.cyclops.integrateddynamics.core.network.diagnostics.http.DiagnosticsWebServer;
import org.cyclops.integrateddynamics.network.packet.NetworkDiagnosticsSubscribePacket;
import org.cyclops.integrateddynamics.proxy.ClientProxy;

public class NetworkDiagnosticsTriggerClient
extends PacketCodec {
    @CodecField
    private boolean start;
    @CodecField
    private int port;

    public NetworkDiagnosticsTriggerClient(boolean start, int port) {
        this.start = start;
        this.port = port;
    }

    public NetworkDiagnosticsTriggerClient() {
        this(true, 0);
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
        if (this.start) {
            if (ClientProxy.DIAGNOSTICS_SERVER == null) {
                IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)NetworkDiagnosticsSubscribePacket.subscribe());
                new Thread(() -> {
                    ClientProxy.DIAGNOSTICS_SERVER = new DiagnosticsWebServer(this.port);
                    ClientProxy.DIAGNOSTICS_SERVER.initialize();
                    player.m_213846_((Component)Component.m_237113_((String)"Diagnostics server has been started on ").m_7220_((Component)Component.m_237113_((String)ClientProxy.DIAGNOSTICS_SERVER.getUrl()).m_6270_(Style.f_131099_.m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, ClientProxy.DIAGNOSTICS_SERVER.getUrl())))));
                }).start();
            } else {
                player.m_213846_((Component)Component.m_237113_((String)"Diagnostics server is already running on ").m_7220_((Component)Component.m_237113_((String)ClientProxy.DIAGNOSTICS_SERVER.getUrl()).m_6270_(Style.f_131099_.m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, ClientProxy.DIAGNOSTICS_SERVER.getUrl())))));
            }
        } else if (ClientProxy.DIAGNOSTICS_SERVER != null) {
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)NetworkDiagnosticsSubscribePacket.unsubscribe());
            new Thread(() -> {
                NetworkDiagnosticsPartOverlayRenderer.getInstance().clearPositions();
                NetworkDataClient.clearNetworkData();
                ClientProxy.DIAGNOSTICS_SERVER.deinitialize();
                ClientProxy.DIAGNOSTICS_SERVER = null;
                player.m_213846_((Component)Component.m_237113_((String)"Stopped diagnostics server"));
            }).start();
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"No diagnostics server is running"));
        }
    }

    public void actionServer(Level world, ServerPlayer player) {
    }
}

