/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui.container;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetNumberField;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.client.gui.image.Image;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerPartOffset;

public class ContainerScreenPartOffset<T extends ContainerPartOffset>
extends ContainerScreenExtended<T> {
    private WidgetNumberField numberFieldX = null;
    private WidgetNumberField numberFieldY = null;
    private WidgetNumberField numberFieldZ = null;

    public ContainerScreenPartOffset(T container, Inventory inventory, Component title) {
        super(container, inventory, title);
    }

    protected void onSave() {
        try {
            ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.m_6262_()), (int)((ContainerPartOffset)this.m_6262_()).getLastXValueId(), (int)this.numberFieldX.getInt());
            ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.m_6262_()), (int)((ContainerPartOffset)this.m_6262_()).getLastYValueId(), (int)this.numberFieldY.getInt());
            ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.m_6262_()), (int)((ContainerPartOffset)this.m_6262_()).getLastZValueId(), (int)this.numberFieldZ.getInt());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected ResourceLocation constructGuiTexture() {
        return new ResourceLocation("integrateddynamics", "textures/gui/part_offsets.png");
    }

    public void m_7856_() {
        super.m_7856_();
        this.numberFieldX = new WidgetNumberField(this.f_96547_, this.f_97735_ + 107 - 54 - 7 - 18, this.f_97736_ + 33, 46, 14, true, (Component)Component.m_237115_((String)"gui.integrateddynamics.partsettings.partoffset.x"), true);
        this.numberFieldX.m_94199_(4);
        this.numberFieldX.setMaxValue(GeneralConfig.maxPartOffset);
        this.numberFieldX.setMinValue(-GeneralConfig.maxPartOffset);
        this.numberFieldX.m_94194_(true);
        this.numberFieldX.m_94202_(0xFFFFFF);
        this.numberFieldX.m_94190_(true);
        this.numberFieldY = new WidgetNumberField(this.f_96547_, this.f_97735_ + 107 - 54 + 36 - 7, this.f_97736_ + 33, 46, 14, true, (Component)Component.m_237115_((String)"gui.integrateddynamics.partsettings.partoffset.x"), true);
        this.numberFieldY.m_94199_(4);
        this.numberFieldY.setMaxValue(GeneralConfig.maxPartOffset);
        this.numberFieldY.setMinValue(-GeneralConfig.maxPartOffset);
        this.numberFieldY.m_94194_(true);
        this.numberFieldY.m_94202_(0xFFFFFF);
        this.numberFieldY.m_94190_(true);
        this.numberFieldZ = new WidgetNumberField(this.f_96547_, this.f_97735_ + 107 - 54 + 72 - 7 + 18, this.f_97736_ + 33, 46, 14, true, (Component)Component.m_237115_((String)"gui.integrateddynamics.partsettings.partoffset.x"), true);
        this.numberFieldZ.m_94199_(4);
        this.numberFieldZ.setMaxValue(GeneralConfig.maxPartOffset);
        this.numberFieldZ.setMinValue(-GeneralConfig.maxPartOffset);
        this.numberFieldZ.m_94194_(true);
        this.numberFieldZ.m_94202_(0xFFFFFF);
        this.numberFieldZ.m_94190_(true);
        MutableComponent save = Component.m_237115_((String)"gui.integrateddynamics.button.save");
        this.m_142416_((GuiEventListener)new ButtonText(this.f_97735_ + 178, this.f_97736_ + 6, this.f_96547_.m_92724_(save.m_7532_()) + 6, 16, (Component)save, (Component)save, this.createServerPressable("button_save", b -> this.onSave()), true));
        this.refreshValues();
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        if (!(this.numberFieldX.m_5534_(typedChar, keyCode) || this.numberFieldY.m_5534_(typedChar, keyCode) || this.numberFieldZ.m_5534_(typedChar, keyCode))) {
            this.onSave();
            return super.m_5534_(typedChar, keyCode);
        }
        return true;
    }

    public boolean m_7933_(int typedChar, int keyCode, int modifiers) {
        if (typedChar != 256) {
            if (this.numberFieldX.m_7933_(typedChar, keyCode, modifiers) || this.numberFieldY.m_7933_(typedChar, keyCode, modifiers) || this.numberFieldZ.m_7933_(typedChar, keyCode, modifiers)) {
                this.onSave();
                return true;
            }
            return true;
        }
        return super.m_7933_(typedChar, keyCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.numberFieldX.m_6375_(mouseX, mouseY, mouseButton) || this.numberFieldY.m_6375_(mouseX, mouseY, mouseButton) || this.numberFieldZ.m_6375_(mouseX, mouseY, mouseButton)) {
            this.onSave();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
        this.f_96547_.m_271703_("X", (float)(this.f_97735_ + 45 + 5), (float)(this.f_97736_ + 19), Helpers.RGBToInt((int)0, (int)0, (int)0), false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        this.f_96547_.m_271703_("Y", (float)(this.f_97735_ + 99 + 5), (float)(this.f_97736_ + 19), Helpers.RGBToInt((int)0, (int)0, (int)0), false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        this.f_96547_.m_271703_("Z", (float)(this.f_97735_ + 153 + 5), (float)(this.f_97736_ + 19), Helpers.RGBToInt((int)0, (int)0, (int)0), false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        this.numberFieldX.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.numberFieldY.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.numberFieldZ.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < 3; ++i) {
            int x = this.f_97735_ + 64 + i * 54;
            if (!((ContainerPartOffset)this.m_6262_()).isOffsetVariableFilled(i)) continue;
            Image image = ((ContainerPartOffset)this.container).getOffsetVariableError(i) == null ? Images.OK : Images.ERROR;
            image.draw(guiGraphics, x, this.f_97736_ + 52);
        }
        if (((ContainerPartOffset)this.m_6262_()).getMaxOffset() == 0) {
            Images.ERROR.draw(guiGraphics, this.f_97735_ + 74, this.f_97736_ + 3);
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.f_96547_.m_272077_((Component)Component.m_237115_((String)"gui.integrateddynamics.part_offsets"), (float)this.f_97728_, (float)this.f_97729_, 0x404040, false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        if (this.m_6774_(0, 0, 90, 18, mouseX, mouseY)) {
            ArrayList lines = Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"gui.integrateddynamics.partoffset.offsets"), Component.m_237110_((String)"gui.integrateddynamics.partoffset.offsets.max", (Object[])new Object[]{((ContainerPartOffset)this.m_6262_()).getMaxOffset()}).m_130940_(ChatFormatting.GRAY)});
            if (((ContainerPartOffset)this.m_6262_()).getMaxOffset() == 0) {
                lines.add(Component.m_237110_((String)"gui.integrateddynamics.partoffset.offsets.max.howtoincrease", (Object[])new Object[]{((ContainerPartOffset)this.m_6262_()).getMaxOffset()}).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
            }
            this.drawTooltip(lines, guiGraphics.m_280168_(), mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        int i = 0;
        while (i < 3) {
            int x = 64 + i * 54;
            int slot = i++;
            GuiHelpers.renderTooltipOptional((AbstractContainerScreen)this, (PoseStack)guiGraphics.m_280168_(), (int)x, (int)52, (int)14, (int)13, (int)mouseX, (int)mouseY, () -> {
                Component unlocalizedMessage = ((ContainerPartOffset)this.container).getOffsetVariableError(slot);
                if (unlocalizedMessage != null) {
                    return Optional.of(Collections.singletonList(unlocalizedMessage));
                }
                return Optional.empty();
            });
        }
    }

    protected int getBaseXSize() {
        return 214;
    }

    protected int getBaseYSize() {
        return 155;
    }

    public void onUpdate(int valueId, CompoundTag value) {
        if (valueId == ((ContainerPartOffset)this.m_6262_()).getLastXValueId()) {
            this.numberFieldX.m_94144_(Integer.toString(((ContainerPartOffset)this.m_6262_()).getLastXValue()));
        }
        if (valueId == ((ContainerPartOffset)this.m_6262_()).getLastYValueId()) {
            this.numberFieldY.m_94144_(Integer.toString(((ContainerPartOffset)this.m_6262_()).getLastYValue()));
        }
        if (valueId == ((ContainerPartOffset)this.m_6262_()).getLastZValueId()) {
            this.numberFieldZ.m_94144_(Integer.toString(((ContainerPartOffset)this.m_6262_()).getLastZValue()));
        }
        this.numberFieldX.m_94186_(!((ContainerPartOffset)this.m_6262_()).isOffsetVariableFilled(0));
        this.numberFieldY.m_94186_(!((ContainerPartOffset)this.m_6262_()).isOffsetVariableFilled(1));
        this.numberFieldZ.m_94186_(!((ContainerPartOffset)this.m_6262_()).isOffsetVariableFilled(2));
        if (valueId == ((ContainerPartOffset)this.m_6262_()).getMaxOffsetId()) {
            int max = ((ContainerPartOffset)this.m_6262_()).getMaxOffset();
            this.numberFieldX.setMaxValue(max);
            this.numberFieldX.setMinValue(-max);
            this.numberFieldY.setMaxValue(max);
            this.numberFieldY.setMinValue(-max);
            this.numberFieldZ.setMaxValue(max);
            this.numberFieldZ.setMinValue(-max);
        }
    }
}

