/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.tank.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.CustomTank;
import mcjty.lib.varia.NBTTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.tank.TankConfiguration;
import mcjty.rftoolsutility.modules.tank.TankModule;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TankTE
extends GenericTileEntity {
    public static final int SLOT_FILTER = 0;
    public static final ModelProperty<Integer> AMOUNT = new ModelProperty();
    public static final ModelProperty<Fluid> FLUID = new ModelProperty();
    private int amount = -1;
    private Fluid clientFluid = null;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(1).slot(SlotDefinition.specific(s -> s.m_41720_() instanceof BucketItem).in().out(), 0, 151, 10).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((slot, stack) -> stack.m_41720_() instanceof BucketItem).onUpdate((slot, stack) -> this.updateFilterFluid((ItemStack)stack)).build();
    @Cap(type=CapType.FLUIDS)
    private final CustomTank fluidHandler = this.createFluidHandler();
    @Cap(type=CapType.CONTAINER)
    private final Lazy<MenuProvider> screenHandler = Lazy.of(() -> new DefaultContainerProvider("Tank").containerSupplier(DefaultContainerProvider.container(TankModule.CONTAINER_TANK, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).setupSync((GenericTileEntity)this));
    private Fluid filterFluid = null;

    public TankTE(BlockPos pos, BlockState state) {
        super(TankModule.TYPE_TANK.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).tileEntitySupplier(TankTE::new).manualEntry(ManualHelper.create((String)"rftoolsutility:machines/tank")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"contents", stack -> TankTE.getFluidString(stack) + " (" + Integer.toString((Integer)TankConfiguration.MAXCAPACITY.get()) + " mb)")})){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }
        };
    }

    private static String getFluidString(ItemStack stack) {
        return (String)NBTTools.getInfoNBT((ItemStack)stack, (info, s) -> {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)info.m_128469_(s));
            if (fluid.isEmpty()) {
                return "<empty>";
            }
            return fluid.getAmount() + "mb " + fluid.getDisplayName().getString();
        }, (String)"tank", (Object)"<empty");
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.amount = tagCompound.m_128451_("level");
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        tagCompound.m_128405_("level", this.amount);
        super.m_183515_(tagCompound);
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        CompoundTag info = tagCompound.m_128469_("Info");
        this.fluidHandler.readFromNBT(info.m_128469_("tank"));
        this.clientFluid = this.fluidHandler.getFluid().getFluid();
        this.amount = tagCompound.m_128451_("level");
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        CompoundTag nbt = new CompoundTag();
        this.fluidHandler.writeToNBT(nbt);
        info.m_128365_("tank", (Tag)nbt);
        tagCompound.m_128405_("level", this.amount);
    }

    protected void loadCaps(CompoundTag tagCompound) {
        super.loadCaps(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.fluidHandler.readFromNBT(info.m_128469_("tank"));
        this.clientFluid = this.fluidHandler.getFluid().getFluid();
        this.updateFilterFluid(this.items.getStackInSlot(0));
    }

    private void updateFilterFluid(ItemStack stack) {
        this.filterFluid = FluidUtil.getFluidContained((ItemStack)stack).map(FluidStack::getFluid).orElse(null);
    }

    protected void saveCaps(CompoundTag tagCompound) {
        super.saveCaps(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        CompoundTag nbt = new CompoundTag();
        this.fluidHandler.writeToNBT(nbt);
        info.m_128365_("tank", (Tag)nbt);
    }

    public InteractionResult onBlockActivated(BlockState state, Player player, InteractionHand hand, BlockHitResult result) {
        if (!this.f_58857_.f_46443_) {
            ItemStack heldItem = player.m_21120_(hand);
            FluidActionResult fillResult = FluidUtil.tryEmptyContainerAndStow((ItemStack)heldItem, (IFluidHandler)this.fluidHandler, null, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
            if (fillResult.isSuccess()) {
                player.m_21008_(hand, fillResult.getResult());
                return InteractionResult.SUCCESS;
            }
            fillResult = FluidUtil.tryFillContainerAndStow((ItemStack)heldItem, (IFluidHandler)this.fluidHandler, null, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
            if (fillResult.isSuccess()) {
                player.m_21008_(hand, fillResult.getResult());
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        int oldLevel = this.computeLevel(this.fluidHandler);
        super.onDataPacket(net, packet);
        this.amount = this.computeLevel(this.fluidHandler);
        if (oldLevel != this.amount || !this.fluidHandler.getFluid().getFluid().equals(this.clientFluid)) {
            this.clientFluid = this.fluidHandler.getFluid().getFluid();
            this.requestModelDataUpdate();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private void updateLevel(CustomTank tank) {
        this.markDirtyQuick();
        int newlevel = this.computeLevel(tank);
        if (this.amount != newlevel || !tank.getFluid().getFluid().equals(this.clientFluid)) {
            this.amount = newlevel;
            this.clientFluid = tank.getFluid().getFluid();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private int computeLevel(CustomTank tank) {
        int amount = tank.getFluidAmount();
        if (amount <= 0) {
            return 0;
        }
        int total = 8 * amount / tank.getCapacity() + 1;
        if (total > 8) {
            total = 8;
        }
        return total;
    }

    @Nonnull
    private CustomTank createFluidHandler() {
        return new CustomTank((Integer)TankConfiguration.MAXCAPACITY.get()){

            protected void onContentsChanged() {
                TankTE.this.updateLevel(this);
            }

            public boolean isFluidValid(FluidStack stack) {
                if (TankTE.this.filterFluid == null) {
                    return true;
                }
                return TankTE.this.filterFluid == stack.getFluid();
            }
        };
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(AMOUNT, (Object)this.amount).with(FLUID, (Object)this.clientFluid).build();
    }
}

