/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modules;

import java.util.Objects;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.data.IModuleDataInteger;
import mcjty.rftoolsutility.modules.logic.tools.RedstoneChannels;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class RedstoneScreenModule
implements IScreenModule<IModuleDataInteger> {
    private int channel = -1;
    private BlockPos coordinate = BlockPosTools.INVALID;
    private ResourceKey<Level> dim = Level.f_46428_;
    private Direction side = null;

    public IModuleDataInteger getData(IScreenDataHelper helper, Level worldObj, long millis) {
        if (this.channel == -1) {
            ServerLevel world;
            if (!BlockPosTools.INVALID.equals((Object)this.coordinate) && (world = LevelTools.getLevel((Level)worldObj, this.dim)) != null) {
                int powerTo = world.m_277185_(this.coordinate.m_121945_(this.side), this.side.m_122424_());
                return helper.createInteger(powerTo);
            }
            return null;
        }
        RedstoneChannels channels = RedstoneChannels.getChannels(worldObj);
        if (channels == null) {
            return null;
        }
        RedstoneChannels.RedstoneChannel ch = channels.getChannel(this.channel);
        if (ch == null) {
            return null;
        }
        return helper.createInteger(ch.getValue());
    }

    public void setupFromNBT(CompoundTag tagCompound, ResourceKey<Level> dim, BlockPos pos) {
        if (tagCompound != null) {
            this.channel = -1;
            if (tagCompound.m_128441_("channel")) {
                this.channel = tagCompound.m_128451_("channel");
            }
            if (tagCompound.m_128441_("monitorx")) {
                this.side = OrientationTools.DIRECTION_VALUES[tagCompound.m_128451_("monitorside")];
                this.dim = LevelTools.getId((String)tagCompound.m_128461_("monitordim"));
                if (Objects.equals(dim, this.dim)) {
                    BlockPos c = new BlockPos(tagCompound.m_128451_("monitorx"), tagCompound.m_128451_("monitory"), tagCompound.m_128451_("monitorz"));
                    int dx = Math.abs(c.m_123341_() - pos.m_123341_());
                    int dy = Math.abs(c.m_123342_() - pos.m_123342_());
                    int dz = Math.abs(c.m_123343_() - pos.m_123343_());
                    if (dx <= 64 && dy <= 64 && dz <= 64) {
                        this.coordinate = c;
                    }
                }
            }
        }
    }

    public int getRfPerTick() {
        return (Integer)ScreenConfiguration.REDSTONE_RFPERTICK.get();
    }

    public void mouseClick(Level world, int x, int y, boolean clicked, Player player) {
    }
}

