/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import java.util.HashSet;
import java.util.Set;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.lib.varia.LogicFacing;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;

public class AnalogTileEntity
extends GenericTileEntity {
    private final LogicSupport support = new LogicSupport();
    @GuiValue(name="mul_eq")
    private float mulEqual = 1.0f;
    @GuiValue(name="mul_less")
    private float mulLess = 1.0f;
    @GuiValue(name="mul_greater")
    private float mulGreater = 1.0f;
    @GuiValue(name="add_eq")
    private int addEqual = 0;
    @GuiValue(name="add_less")
    private int addLess = 0;
    @GuiValue(name="add_greater")
    private int addGreater = 0;
    @Cap(type=CapType.CONTAINER)
    private final Lazy<MenuProvider> screenHandler = Lazy.of(() -> new DefaultContainerProvider("Analog").containerSupplier(DefaultContainerProvider.empty(LogicBlockModule.CONTAINER_ANALOG, (GenericTileEntity)this)).setupSync((GenericTileEntity)this));
    private static final Set<BlockPos> loopDetector = new HashSet<BlockPos>();

    public AnalogTileEntity(BlockPos pos, BlockState state) {
        super(LogicBlockModule.TYPE_ANALOG.get(), pos, state);
    }

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsutility:logic/analog")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(AnalogTileEntity::new));
    }

    public void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.mulEqual = info.m_128457_("mulE");
        this.mulLess = info.m_128457_("mulL");
        this.mulGreater = info.m_128457_("mulG");
        this.addEqual = info.m_128451_("addE");
        this.addLess = info.m_128451_("addL");
        this.addGreater = info.m_128451_("addG");
    }

    public void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        info.m_128350_("mulE", this.mulEqual);
        info.m_128350_("mulL", this.mulLess);
        info.m_128350_("mulG", this.mulGreater);
        info.m_128405_("addE", this.addEqual);
        info.m_128405_("addL", this.addLess);
        info.m_128405_("addG", this.addGreater);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRedstone(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (loopDetector.add(pos)) {
            try {
                LogicFacing facing = LogicSupport.getFacing((BlockState)state);
                Direction downSide = facing.getSide();
                Direction inputSide = facing.getInputSide();
                Direction rightSide = LogicSlabBlock.rotateLeft((Direction)downSide, (Direction)inputSide);
                Direction leftSide = LogicSlabBlock.rotateRight((Direction)downSide, (Direction)inputSide);
                int inputStrength = this.support.getInputStrength(world, pos, inputSide);
                int inputLeft = this.support.getInputStrength(world, pos, leftSide);
                int inputRight = this.support.getInputStrength(world, pos, rightSide);
                int outputStrength = inputLeft == inputRight ? (int)((float)inputStrength * this.mulEqual + (float)this.addEqual) : (inputLeft < inputRight ? (int)((float)inputStrength * this.mulLess + (float)this.addLess) : (int)((float)inputStrength * this.mulGreater + (float)this.addGreater));
                if (outputStrength > 15) {
                    outputStrength = 15;
                } else if (outputStrength < 0) {
                    outputStrength = 0;
                }
                int oldPower = this.support.getPowerOutput();
                this.support.setRedstoneState((GenericTileEntity)this, outputStrength);
                if (oldPower != outputStrength) {
                    world.m_46672_(pos, this.m_58900_().m_60734_());
                }
            }
            finally {
                loopDetector.remove(pos);
            }
        }
    }

    public int getRedstoneOutput(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return this.support.getRedstoneOutput(state, side);
    }
}

