/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.integrations.jei.category;

import com.enderio.machines.client.gui.screen.EnchanterScreen;
import com.enderio.machines.common.init.MachineBlocks;
import com.enderio.machines.common.integrations.jei.util.MachineRecipeCategory;
import com.enderio.machines.common.integrations.jei.util.WrappedEnchanterRecipe;
import com.enderio.machines.common.lang.MachineLang;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class EnchanterCategory
extends MachineRecipeCategory<WrappedEnchanterRecipe> {
    public static final RecipeType<WrappedEnchanterRecipe> TYPE = RecipeType.create((String)"enderio", (String)"enchanter", WrappedEnchanterRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public EnchanterCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(EnchanterScreen.BG_TEXTURE, 15, 24, 146, 40);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)MachineBlocks.ENCHANTER.get()));
    }

    public RecipeType<WrappedEnchanterRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return MachineLang.CATEGORY_ENCHANTER;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, WrappedEnchanterRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 11).addItemStack(new ItemStack((ItemLike)Items.f_42614_));
        builder.addSlot(RecipeIngredientRole.INPUT, 50, 11).addItemStacks(recipe.getInputs());
        builder.addSlot(RecipeIngredientRole.INPUT, 70, 11).addItemStacks(recipe.getLapis());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 129, 11).addItemStack(recipe.getBook());
    }

    public void draw(WrappedEnchanterRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        Component title = recipe.getEnchantment().m_44700_(recipe.getLevel());
        guiGraphics.m_280614_(mc.f_91062_, title, 146 - mc.f_91062_.m_92852_((FormattedText)title), 0, -7631989, false);
        int cost = recipe.getCost();
        String costText = cost < 0 ? "err" : Integer.toString(cost);
        String text = I18n.m_118938_((String)"container.repair.cost", (Object[])new Object[]{costText});
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        int mainColor = EnchanterCategory.playerHasEnoughLevels(player, cost) ? -8323296 : -40864;
        int repairTextWidth = minecraft.f_91062_.m_92895_(text);
        guiGraphics.m_280488_(minecraft.f_91062_, text, this.background.getWidth() - 2 - repairTextWidth, this.background.getHeight() - 8, mainColor);
    }
}

