/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity.capacitorbank;

import com.enderio.api.capacitor.FixedScalable;
import com.enderio.api.io.energy.EnergyIOMode;
import com.enderio.base.common.tag.EIOTags;
import com.enderio.core.common.network.slot.ListNetworkDataSlot;
import com.enderio.core.common.network.slot.LongNetworkDataSlot;
import com.enderio.core.common.network.slot.NBTSerializingNetworkDataSlot;
import com.enderio.core.common.network.slot.NetworkDataSlot;
import com.enderio.machines.common.blockentity.base.MultiConfigurable;
import com.enderio.machines.common.blockentity.base.PoweredMachineBlockEntity;
import com.enderio.machines.common.blockentity.capacitorbank.DisplayMode;
import com.enderio.machines.common.blockentity.multienergy.ICapacityTier;
import com.enderio.machines.common.blockentity.multienergy.MultiEnergyNode;
import com.enderio.machines.common.blockentity.multienergy.MultiEnergyStorageWrapper;
import com.enderio.machines.common.blockentity.sync.LargeMachineEnergyDataSlot;
import com.enderio.machines.common.io.energy.ILargeMachineEnergyStorage;
import com.enderio.machines.common.io.energy.IMachineEnergyStorage;
import com.enderio.machines.common.io.energy.MachineEnergyStorage;
import com.enderio.machines.common.menu.CapacitorBankMenu;
import dev.gigaherz.graph3.Graph;
import dev.gigaherz.graph3.GraphObject;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CapacitorBankBlockEntity
extends PoweredMachineBlockEntity
implements MultiConfigurable {
    public final ICapacityTier tier;
    private final MultiEnergyNode node;
    private long addedEnergy = 0L;
    private long removedEnergy = 0L;
    public static final int AVERAGE_IO_OVER_X_TICKS = 10;
    private final List<BlockPos> clientConfigurables = new ArrayList<BlockPos>();
    private static final String DISPLAY_MODES = "displaymodes";
    private final Map<Direction, DisplayMode> displayModes = (Map)Util.m_137537_(() -> {
        EnumMap<Direction, DisplayMode> map = new EnumMap<Direction, DisplayMode>(Direction.class);
        for (Direction direction : new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST}) {
            map.put(direction, DisplayMode.NONE);
        }
        return map;
    });

    public CapacitorBankBlockEntity(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState, ICapacityTier tier) {
        super(EnergyIOMode.Both, new FixedScalable(tier::getStorageCapacity), new FixedScalable(tier::getStorageCapacity), type, worldPosition, blockState);
        this.tier = tier;
        this.node = new MultiEnergyNode(() -> this.energyStorage, () -> (MultiEnergyStorageWrapper)this.getExposedEnergyStorage(), worldPosition);
        this.addDataSlot(new LongNetworkDataSlot(() -> this.addedEnergy, syncAddedEnergy -> {
            this.addedEnergy = syncAddedEnergy;
        }));
        this.addDataSlot(new LongNetworkDataSlot(() -> this.removedEnergy, syncRemovedEnergy -> {
            this.removedEnergy = syncRemovedEnergy;
        }));
        this.addDataSlot(new ConfigurablesDataSlot());
        this.addDataSlot(new NBTSerializingNetworkDataSlot<Map>(() -> this.displayModes, modes -> this.saveDisplayModes(), (modes, nbt) -> this.loadDisplayModes((CompoundTag)nbt), (modes, friendlyByteBuf) -> friendlyByteBuf.m_130079_(this.saveDisplayModes()), friendlyByteBuf -> {
            CompoundTag tag = friendlyByteBuf.m_130260_();
            this.loadDisplayModes(tag);
            return this.displayModes;
        }));
    }

    @Override
    public NetworkDataSlot<?> createEnergyDataSlot() {
        return new LargeMachineEnergyDataSlot(() -> (ILargeMachineEnergyStorage)((Object)this.getExposedEnergyStorage()), storage -> {
            this.clientEnergyStorage = (IMachineEnergyStorage)((Object)storage);
        });
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new CapacitorBankMenu(this, pPlayerInventory, pContainerId);
    }

    @Override
    @Nullable
    public MachineEnergyStorage createExposedEnergyStorage() {
        return new MultiEnergyStorageWrapper(this.getIOConfig(), EnergyIOMode.Both, () -> this.tier);
    }

    @Override
    public void serverTick() {
        super.serverTick();
        if (this.f_58857_.m_46467_() % 10L == 0L && this.node.getWrapper().get().getLastResetTime() != this.f_58857_.m_46467_() && this.node.getGraph() != null) {
            MultiEnergyNode graphNode;
            this.addedEnergy = 0L;
            this.removedEnergy = 0L;
            ArrayList nodes = new ArrayList(this.node.getGraph().getObjects());
            for (GraphObject object : nodes) {
                if (!(object instanceof MultiEnergyNode)) continue;
                graphNode = (MultiEnergyNode)object;
                this.addedEnergy += graphNode.getWrapper().get().getAddedEnergy();
                this.removedEnergy += graphNode.getWrapper().get().getRemovedEnergy();
                graphNode.getWrapper().get().resetEnergyStats(this.f_58857_.m_46467_());
            }
            for (GraphObject object : nodes) {
                if (!(object instanceof MultiEnergyNode)) continue;
                graphNode = (MultiEnergyNode)object;
                BlockEntity blockEntity = this.f_58857_.m_7702_(graphNode.pos);
                if (!(blockEntity instanceof CapacitorBankBlockEntity)) continue;
                CapacitorBankBlockEntity capacitorBank = (CapacitorBankBlockEntity)blockEntity;
                capacitorBank.addedEnergy = this.addedEnergy;
                capacitorBank.removedEnergy = this.removedEnergy;
            }
        }
        if (this.f_58857_.m_46467_() % 200L == (long)(this.hashCode() % 200) && this.node.getGraph() != null && List.copyOf(this.node.getGraph().getObjects()).indexOf(this.node) == 0) {
            long cumulativeEnergy = 0L;
            for (Object object : this.node.getGraph().getObjects()) {
                if (!(object instanceof MultiEnergyNode)) continue;
                MultiEnergyNode otherNode = (MultiEnergyNode)object;
                cumulativeEnergy += (long)otherNode.getInternal().get().getEnergyStored();
            }
            int energyPerNode = (int)(cumulativeEnergy / (long)this.node.getGraph().getObjects().size());
            for (GraphObject object : this.node.getGraph().getObjects()) {
                if (!(object instanceof MultiEnergyNode)) continue;
                MultiEnergyNode otherNode = (MultiEnergyNode)object;
                ((MachineEnergyStorage)otherNode.getInternal().get()).setEnergyStored(Math.min(energyPerNode, (int)Math.min(cumulativeEnergy, Integer.MAX_VALUE)));
                cumulativeEnergy -= (long)energyPerNode;
            }
            int remainingEnergy = (int)cumulativeEnergy;
            if (remainingEnergy <= 0) {
                return;
            }
            for (GraphObject object : this.node.getGraph().getObjects()) {
                MultiEnergyNode otherNode;
                int received;
                if (!(object instanceof MultiEnergyNode) || (remainingEnergy -= (received = (otherNode = (MultiEnergyNode)object).getInternal().get().receiveEnergy(remainingEnergy, false))) > 0) continue;
                return;
            }
        }
    }

    @Override
    protected boolean isActive() {
        return true;
    }

    @Override
    public void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_(DISPLAY_MODES, (Tag)this.saveDisplayModes());
    }

    public CompoundTag saveDisplayModes() {
        CompoundTag nbt = new CompoundTag();
        for (Map.Entry<Direction, DisplayMode> entry : this.displayModes.entrySet()) {
            nbt.m_128405_(entry.getKey().m_122433_(), entry.getValue().ordinal());
        }
        return nbt;
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128425_(DISPLAY_MODES, 10)) {
            this.loadDisplayModes(pTag.m_128469_(DISPLAY_MODES));
        }
    }

    public void loadDisplayModes(CompoundTag nbt) {
        this.displayModes.clear();
        for (String key : nbt.m_128431_()) {
            @Nullable Direction dir = Direction.m_122402_((String)key);
            if (dir == null) continue;
            this.displayModes.put(dir, DisplayMode.values()[nbt.m_128451_(key)]);
        }
    }

    @Override
    protected boolean shouldPushEnergyTo(Direction direction) {
        if (this.node.getGraph() == null) {
            return true;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
        if (blockEntity instanceof CapacitorBankBlockEntity) {
            CapacitorBankBlockEntity capacitorBank = (CapacitorBankBlockEntity)blockEntity;
            return capacitorBank.node.getGraph() != this.node.getGraph();
        }
        return true;
    }

    public void m_7651_() {
        if (this.node.getGraph() != null) {
            this.node.getGraph().remove((GraphObject)this.node);
        }
        super.m_7651_();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.node.getGraph() == null) {
            Graph.integrate((GraphObject)this.node, List.of());
        }
        for (Direction direction : Direction.values()) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
            if (!(blockEntity instanceof CapacitorBankBlockEntity)) continue;
            CapacitorBankBlockEntity capacitor = (CapacitorBankBlockEntity)blockEntity;
            if (capacitor.tier != this.tier) continue;
            Graph.connect((GraphObject)this.node, (GraphObject)capacitor.node);
        }
    }

    @Override
    public List<BlockPos> getConfigurables() {
        return this.clientConfigurables;
    }

    private void setPositions(List<BlockPos> list) {
        this.clientConfigurables.clear();
        this.clientConfigurables.addAll(list);
    }

    private List<BlockPos> getPositions() {
        if (this.node.getGraph() == null) {
            return List.of();
        }
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (GraphObject object : this.node.getGraph().getObjects()) {
            if (!(object instanceof MultiEnergyNode)) continue;
            MultiEnergyNode otherNode = (MultiEnergyNode)object;
            positions.add(otherNode.pos);
        }
        return positions;
    }

    public boolean onShiftRightClick(Direction direction, Player player) {
        if (direction.m_122434_().m_122480_() == Direction.Plane.VERTICAL) {
            return false;
        }
        if (player.m_21205_().m_41720_() instanceof BlockItem || player.m_21206_().m_41720_() instanceof BlockItem) {
            return false;
        }
        if (player.m_21205_().m_204117_(EIOTags.Items.WRENCH)) {
            return false;
        }
        this.displayModes.put(direction, DisplayMode.values()[(this.displayModes.get(direction).ordinal() + 1) % DisplayMode.values().length]);
        return true;
    }

    public long getAddedEnergy() {
        return this.addedEnergy / 10L;
    }

    public long getRemovedEnergy() {
        return this.removedEnergy / 10L;
    }

    public DisplayMode getDisplayMode(Direction direction) {
        if (this.m_58904_() == null || !Block.m_152444_((BlockState)this.m_58900_(), (BlockGetter)this.m_58904_(), (BlockPos)this.f_58858_, (Direction)direction, (BlockPos)this.f_58858_.m_121945_(direction))) {
            return DisplayMode.NONE;
        }
        return this.displayModes.get(direction);
    }

    public void setDisplayMode(Direction direction, DisplayMode mode) {
        this.displayModes.put(direction, mode);
    }

    public AABB getRenderBoundingBox() {
        return AABB.m_165882_((Vec3)new Vec3((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_()), (double)32.0, (double)32.0, (double)32.0);
    }

    private class ConfigurablesDataSlot
    extends ListNetworkDataSlot<BlockPos, CompoundTag> {
        ConfigurablesDataSlot() {
            super(CapacitorBankBlockEntity.this::getPositions, CapacitorBankBlockEntity.this::setPositions, blockPos -> {
                CompoundTag tag = new CompoundTag();
                tag.m_128356_("BlockPos", blockPos.m_121878_());
                return tag;
            }, compoundTag -> BlockPos.m_122022_((long)compoundTag.m_128454_("BlockPos")), (blockPos, friendlyByteBuf) -> friendlyByteBuf.writeLong(blockPos.m_121878_()), friendlyByteBuf -> BlockPos.m_122022_((long)friendlyByteBuf.readLong()));
        }
    }
}

