/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.blockentity;

import com.enderio.base.common.init.EIOFluids;
import com.enderio.base.common.util.ExperienceUtil;
import com.enderio.core.common.network.slot.IntegerNetworkDataSlot;
import com.enderio.machines.common.blockentity.base.VacuumMachineBlockEntity;
import com.enderio.machines.common.config.MachinesConfig;
import com.enderio.machines.common.io.fluid.MachineFluidHandler;
import com.enderio.machines.common.io.fluid.MachineFluidTank;
import com.enderio.machines.common.io.fluid.MachineTankLayout;
import com.enderio.machines.common.io.fluid.TankAccess;
import com.enderio.machines.common.menu.XPVacuumMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class XPVacuumBlockEntity
extends VacuumMachineBlockEntity<ExperienceOrb> {
    private static final TankAccess TANK = new TankAccess();

    public XPVacuumBlockEntity(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(pType, pWorldPosition, pBlockState, ExperienceOrb.class);
        this.addDataSlot(new IntegerNetworkDataSlot(() -> TANK.getFluidAmount(this), i -> TANK.setFluid(this, new FluidStack((Fluid)EIOFluids.XP_JUICE.getSource(), i.intValue()))));
    }

    @Override
    public String getColor() {
        return (String)MachinesConfig.CLIENT.BLOCKS.XP_VACUUM_RANGE_COLOR.get();
    }

    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new XPVacuumMenu(this, inventory, containerId);
    }

    @Override
    public void handleEntity(ExperienceOrb xpe) {
        int filled = TANK.fill(this, new FluidStack((Fluid)EIOFluids.XP_JUICE.getSource(), xpe.m_20801_() * ExperienceUtil.EXP_TO_FLUID), IFluidHandler.FluidAction.EXECUTE);
        if (filled == xpe.m_20801_() * ExperienceUtil.EXP_TO_FLUID) {
            xpe.m_146870_();
        } else {
            xpe.f_20770_ = (int)((float)xpe.f_20770_ - (float)filled / (float)ExperienceUtil.EXP_TO_FLUID);
        }
    }

    @Override
    @Nullable
    public MachineTankLayout getTankLayout() {
        return new MachineTankLayout.Builder().tank(TANK, Integer.MAX_VALUE).build();
    }

    @Override
    @Nullable
    protected MachineFluidHandler createFluidHandler(MachineTankLayout layout) {
        return new MachineFluidHandler(this.getIOConfig(), this.getTankLayout()){

            @Override
            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                XPVacuumBlockEntity.this.m_6596_();
            }
        };
    }

    public MachineFluidTank getFluidTank() {
        return TANK.getTank(this);
    }
}

