/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.client.rendering.model;

import com.enderio.EnderIO;
import com.enderio.api.io.IIOConfig;
import com.enderio.api.io.IOMode;
import com.enderio.machines.client.rendering.model.ModelRenderUtil;
import com.enderio.machines.common.blockentity.base.MachineBlockEntity;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class IOOverlayBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation TEX_DISABLED = EnderIO.loc("block/overlay/disabled");
    public static final ResourceLocation TEX_PULL = EnderIO.loc("block/overlay/pull");
    public static final ResourceLocation TEX_PUSH = EnderIO.loc("block/overlay/push");
    public static final ResourceLocation TEX_PUSH_PULL = EnderIO.loc("block/overlay/push_pull");
    private static final EnumMap<Direction, Vec3[]> QUADS = new EnumMap(Direction.class);
    private final Direction north;

    private TextureAtlasSprite getTexture(IOMode state) {
        ResourceLocation tex = switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case IOMode.NONE -> MissingTextureAtlasSprite.m_118071_();
            case IOMode.PUSH -> TEX_PUSH;
            case IOMode.PULL -> TEX_PULL;
            case IOMode.BOTH -> TEX_PUSH_PULL;
            case IOMode.DISABLED -> TEX_DISABLED;
        };
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(tex);
    }

    public IOOverlayBakedModel(ModelState modelState) {
        this.north = Direction.m_252919_((Matrix4f)modelState.m_6189_().m_252783_(), (Direction)Direction.NORTH);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, RenderType renderType) {
        IIOConfig config;
        if (extraData.has(MachineBlockEntity.IO_CONFIG_PROPERTY) && (config = (IIOConfig)extraData.get(MachineBlockEntity.IO_CONFIG_PROPERTY)) != null && config.renderOverlay()) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            for (Direction dir : Direction.values()) {
                IOMode mode = config.getMode(dir);
                if (mode == IOMode.NONE) continue;
                Vec3[] verts = QUADS.get(dir);
                quads.add(ModelRenderUtil.createQuad(verts, this.getTexture(mode)));
            }
            return quads;
        }
        return Collections.emptyList();
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110463_()});
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return null;
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    static {
        for (Direction dir : Direction.values()) {
            QUADS.put(dir, ModelRenderUtil.createQuadVerts(dir, 0.0625, 0.9375, 1.0001));
        }
    }

    public static class Loader
    implements IGeometryLoader<Geometry> {
        public Geometry read(JsonObject modelContents, JsonDeserializationContext deserializationContext) {
            return new Geometry();
        }
    }

    public static class Geometry
    implements IUnbakedGeometry<Geometry> {
        public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
            return new IOOverlayBakedModel(modelState);
        }
    }
}

