/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines;

import com.enderio.EnderIO;
import com.enderio.api.integration.IntegrationManager;
import com.enderio.api.travel.TravelRegistry;
import com.enderio.base.data.EIODataProvider;
import com.enderio.machines.client.rendering.travel.TravelAnchorRenderer;
import com.enderio.machines.common.block.SolarPanelBlock;
import com.enderio.machines.common.blockentity.solar.SolarPanelTier;
import com.enderio.machines.common.config.MachinesConfig;
import com.enderio.machines.common.init.MachineBlockEntities;
import com.enderio.machines.common.init.MachineBlocks;
import com.enderio.machines.common.init.MachineMenus;
import com.enderio.machines.common.init.MachinePackets;
import com.enderio.machines.common.init.MachineRecipes;
import com.enderio.machines.common.integrations.EnderIOMachinesSelfIntegration;
import com.enderio.machines.common.lang.MachineLang;
import com.enderio.machines.common.menu.EnchanterMenu;
import com.enderio.machines.common.menu.GhostMachineSlot;
import com.enderio.machines.common.menu.MachineSlot;
import com.enderio.machines.common.menu.PreviewMachineSlot;
import com.enderio.machines.common.tag.MachineTags;
import com.enderio.machines.common.travel.AnchorTravelTarget;
import com.enderio.machines.data.advancements.MachinesAdvancementGenerator;
import com.enderio.machines.data.recipes.AlloyRecipeProvider;
import com.enderio.machines.data.recipes.EnchanterRecipeProvider;
import com.enderio.machines.data.recipes.MachineRecipeProvider;
import com.enderio.machines.data.recipes.PaintingRecipeProvider;
import com.enderio.machines.data.recipes.SagMillRecipeProvider;
import com.enderio.machines.data.recipes.SlicingRecipeProvider;
import com.enderio.machines.data.recipes.SoulBindingRecipeProvider;
import com.enderio.machines.data.recipes.TankRecipeProvider;
import com.enderio.machines.data.souldata.SoulDataProvider;
import com.enderio.machines.data.tag.MachineEntityTypeTagsProvider;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.registries.MissingMappingsEvent;

@Mod.EventBusSubscriber(modid="enderio", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EIOMachines {
    @SubscribeEvent
    public static void onConstruct(FMLConstructModEvent event) {
        ModLoadingContext ctx = ModLoadingContext.get();
        ctx.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MachinesConfig.COMMON_SPEC, "enderio/machines-common.toml");
        ctx.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)MachinesConfig.CLIENT_SPEC, "enderio/machines-client.toml");
        MachineBlocks.register();
        MachineBlockEntities.register();
        MachineMenus.register();
        MachinePackets.register();
        MachineLang.register();
        MachineRecipes.register();
        MachineTags.register();
        MinecraftForge.EVENT_BUS.addListener(EIOMachines::missingMappings);
        IntegrationManager.addIntegration(EnderIOMachinesSelfIntegration.INSTANCE);
        TravelRegistry.addTravelEntry(EnderIO.loc("travel_anchor"), AnchorTravelTarget::new, () -> TravelAnchorRenderer::new);
    }

    @SubscribeEvent
    public static void sendIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"inventorysorter", (String)"slotblacklist", MachineSlot.class::getName);
        InterModComms.sendTo((String)"inventorysorter", (String)"slotblacklist", GhostMachineSlot.class::getName);
        InterModComms.sendTo((String)"inventorysorter", (String)"slotblacklist", PreviewMachineSlot.class::getName);
        InterModComms.sendTo((String)"inventorysorter", (String)"slotblacklist", EnchanterMenu.EnchanterOutputMachineSlot.class::getName);
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture<HolderLookup.Provider> completablefuture = CompletableFuture.supplyAsync(VanillaRegistries::m_255371_, Util.m_183991_());
        EIODataProvider provider = new EIODataProvider("machines");
        provider.addSubProvider(event.includeServer(), (DataProvider)new MachineRecipeProvider(packOutput));
        provider.addSubProvider(event.includeServer(), (DataProvider)new AlloyRecipeProvider(packOutput));
        provider.addSubProvider(event.includeServer(), (DataProvider)new EnchanterRecipeProvider(packOutput));
        provider.addSubProvider(event.includeServer(), (DataProvider)new SagMillRecipeProvider(packOutput));
        provider.addSubProvider(event.includeServer(), (DataProvider)new SlicingRecipeProvider(packOutput));
        provider.addSubProvider(event.includeServer(), (DataProvider)new SoulBindingRecipeProvider(packOutput));
        provider.addSubProvider(event.includeServer(), (DataProvider)new TankRecipeProvider(packOutput));
        provider.addSubProvider(event.includeServer(), (DataProvider)new PaintingRecipeProvider(packOutput));
        provider.addSubProvider(event.includeServer(), new SoulDataProvider(packOutput));
        provider.addSubProvider(event.includeServer(), (DataProvider)new MachineEntityTypeTagsProvider(packOutput, completablefuture, event.getExistingFileHelper()));
        generator.addProvider(true, (DataProvider)provider);
        provider.addSubProvider(event.includeServer(), (DataProvider)new ForgeAdvancementProvider(packOutput, event.getLookupProvider(), event.getExistingFileHelper(), List.of(new MachinesAdvancementGenerator())));
    }

    public static void missingMappings(MissingMappingsEvent event) {
        event.getMappings(Registries.f_256747_, "enderio").forEach(mapping -> {
            if (mapping.getKey().equals((Object)EnderIO.loc("simple_photovoltaic_cell"))) {
                mapping.remap((Object)((Block)MachineBlocks.SOLAR_PANELS.get(SolarPanelTier.ENERGETIC).get()));
            } else if (mapping.getKey().equals((Object)EnderIO.loc("basic_photovoltaic_cell"))) {
                mapping.remap((Object)((Block)MachineBlocks.SOLAR_PANELS.get(SolarPanelTier.ENERGETIC).get()));
            } else if (mapping.getKey().equals((Object)EnderIO.loc("advanced_photovoltaic_cell"))) {
                mapping.remap((Object)((Block)MachineBlocks.SOLAR_PANELS.get(SolarPanelTier.PULSATING).get()));
            } else if (mapping.getKey().equals((Object)EnderIO.loc("vibrant_photovoltaic_cell"))) {
                mapping.remap((Object)((Block)MachineBlocks.SOLAR_PANELS.get(SolarPanelTier.VIBRANT).get()));
            }
        });
        event.getMappings(Registries.f_256913_, "enderio").forEach(mapping -> {
            if (mapping.getKey().equals((Object)EnderIO.loc("simple_photovoltaic_cell"))) {
                mapping.remap((Object)((SolarPanelBlock)MachineBlocks.SOLAR_PANELS.get(SolarPanelTier.ENERGETIC).get()).m_5456_());
            } else if (mapping.getKey().equals((Object)EnderIO.loc("basic_photovoltaic_cell"))) {
                mapping.remap((Object)((SolarPanelBlock)MachineBlocks.SOLAR_PANELS.get(SolarPanelTier.ENERGETIC).get()).m_5456_());
            } else if (mapping.getKey().equals((Object)EnderIO.loc("advanced_photovoltaic_cell"))) {
                mapping.remap((Object)((SolarPanelBlock)MachineBlocks.SOLAR_PANELS.get(SolarPanelTier.PULSATING).get()).m_5456_());
            } else if (mapping.getKey().equals((Object)EnderIO.loc("vibrant_photovoltaic_cell"))) {
                mapping.remap((Object)((SolarPanelBlock)MachineBlocks.SOLAR_PANELS.get(SolarPanelTier.VIBRANT).get()).m_5456_());
            }
        });
    }
}

