/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.network;

import com.enderio.core.common.network.EmitParticlePacket;
import com.enderio.core.common.network.Packet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class EmitParticlesPacket
implements Packet {
    private final List<EmitParticlePacket> particles = new ArrayList<EmitParticlePacket>();

    public EmitParticlesPacket() {
    }

    public EmitParticlesPacket(FriendlyByteBuf buf) {
        int numParticles = buf.readInt();
        for (int i = 0; i < numParticles; ++i) {
            this.particles.add(new EmitParticlePacket(buf));
        }
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.particles.size());
        for (EmitParticlePacket particle : this.particles) {
            particle.write(buf);
        }
    }

    public void add(EmitParticlePacket particlePacket) {
        this.particles.add(particlePacket);
    }

    public void add(ParticleOptions type, double x, double y, double z) {
        this.add(type, x, y, z, 0.0, 0.0, 0.0);
    }

    public void add(ParticleOptions type, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.add(new EmitParticlePacket(type, x, y, z, xSpeed, ySpeed, zSpeed));
    }

    public void add(BlockPos pos, ParticleOptions type) {
        this.add(new EmitParticlePacket(type, pos));
    }

    @Override
    public boolean isValid(NetworkEvent.Context context) {
        return true;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        for (EmitParticlePacket particle : this.particles) {
            particle.handle(context);
        }
    }

    public static class Handler
    extends Packet.PacketHandler<EmitParticlesPacket> {
        @Override
        public EmitParticlesPacket fromNetwork(FriendlyByteBuf buf) {
            return new EmitParticlesPacket(buf);
        }

        @Override
        public Optional<NetworkDirection> getDirection() {
            return Optional.of(NetworkDirection.PLAY_TO_CLIENT);
        }

        @Override
        public void toNetwork(EmitParticlesPacket packet, FriendlyByteBuf buf) {
            packet.write(buf);
        }
    }
}

