/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.network;

import com.enderio.core.common.blockentity.EnderBlockEntity;
import com.enderio.core.common.network.Packet;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class C2SDataSlotChange
implements Packet {
    private final BlockPos pos;
    @Nullable
    private final FriendlyByteBuf updateData;

    public C2SDataSlotChange(BlockPos pos, FriendlyByteBuf updateData) {
        this.pos = pos;
        this.updateData = updateData;
    }

    public C2SDataSlotChange(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.updateData = new FriendlyByteBuf(buf.copy());
    }

    @Override
    public boolean isValid(NetworkEvent.Context context) {
        return context.getSender() != null && this.updateData != null;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerLevel level = context.getSender().m_284548_();
        BlockEntity be = level.m_7702_(this.pos);
        if (be instanceof EnderBlockEntity) {
            EnderBlockEntity enderBlockEntity = (EnderBlockEntity)be;
            enderBlockEntity.serverHandleBufferChange(this.updateData);
        }
    }

    protected void write(FriendlyByteBuf writeInto) {
        writeInto.m_130064_(this.pos);
        writeInto.writeBytes((ByteBuf)this.updateData);
    }

    public static class Handler
    extends Packet.PacketHandler<C2SDataSlotChange> {
        @Override
        public C2SDataSlotChange fromNetwork(FriendlyByteBuf buf) {
            return new C2SDataSlotChange(buf);
        }

        @Override
        public void toNetwork(C2SDataSlotChange packet, FriendlyByteBuf buf) {
            packet.write(buf);
        }

        @Override
        public Optional<NetworkDirection> getDirection() {
            return Optional.of(NetworkDirection.PLAY_TO_SERVER);
        }
    }
}

