/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.recipe;

import com.enderio.EnderIO;
import com.enderio.base.common.init.EIORecipes;
import com.enderio.core.common.recipes.EnderRecipe;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;

public class FireCraftingRecipe
implements EnderRecipe<Container> {
    private final ResourceLocation id;
    private final ResourceLocation lootTable;
    private final int maxItemDrops;
    private final List<Block> bases;
    private final List<TagKey<Block>> baseTags;
    private final List<ResourceLocation> dimensions;

    public FireCraftingRecipe(ResourceLocation id, ResourceLocation lootTable, int maxItemDrops, List<Block> bases, List<TagKey<Block>> baseTags, List<ResourceLocation> dimensions) {
        this.id = id;
        this.lootTable = lootTable;
        this.maxItemDrops = maxItemDrops;
        this.bases = bases;
        this.baseTags = baseTags;
        this.dimensions = dimensions;
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public int getMaxItemDrops() {
        return this.maxItemDrops;
    }

    public List<Block> getBases() {
        ArrayList<Block> blocks = new ArrayList<Block>(this.bases);
        for (TagKey<Block> blockTagKey : this.baseTags) {
            ITag tag = ForgeRegistries.BLOCKS.tags().getTag(blockTagKey);
            blocks.addAll(tag.stream().toList());
        }
        return blocks;
    }

    public boolean isBaseValid(Block block) {
        for (TagKey<Block> tag : this.baseTags) {
            if (!block.m_49966_().m_204336_(tag)) continue;
            return true;
        }
        return this.bases.contains(block);
    }

    public boolean isDimensionValid(ResourceKey<Level> dimension) {
        return this.dimensions.contains(dimension.m_135782_());
    }

    public List<ResourceLocation> getValidDimensions() {
        return ImmutableList.copyOf(this.dimensions);
    }

    public boolean m_5818_(Container container, Level level) {
        return false;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<FireCraftingRecipe> m_7707_() {
        return (RecipeSerializer)EIORecipes.FIRE_CRAFTING.serializer().get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)EIORecipes.FIRE_CRAFTING.type().get();
    }

    public static class Serializer
    implements RecipeSerializer<FireCraftingRecipe> {
        public FireCraftingRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            ResourceLocation lootTable = new ResourceLocation(serializedRecipe.get("loot_table").getAsString());
            int maxItemDrops = serializedRecipe.get("max_item_drops").getAsInt();
            ArrayList<Block> baseBlocks = new ArrayList<Block>();
            ArrayList<TagKey<Block>> baseTags = new ArrayList<TagKey<Block>>();
            JsonArray baseBlocksJson = serializedRecipe.getAsJsonArray("base_blocks");
            for (JsonElement baseBlock : baseBlocksJson) {
                if (!(baseBlock instanceof JsonObject)) continue;
                JsonObject obj = (JsonObject)baseBlock;
                if (obj.has("block")) {
                    String id = obj.get("block").getAsString();
                    Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(id));
                    if (block == null) {
                        throw new ResourceLocationException("Missing block " + id + " for fire crafting recipe " + String.valueOf(recipeId));
                    }
                    baseBlocks.add(block);
                    continue;
                }
                if (obj.has("tag")) {
                    baseTags.add((TagKey<Block>)BlockTags.create((ResourceLocation)new ResourceLocation(obj.get("tag").getAsString())));
                    continue;
                }
                throw new UnsupportedOperationException("Unknown block entry for fire crafting recipe " + String.valueOf(recipeId));
            }
            ArrayList<ResourceLocation> dimensions = new ArrayList<ResourceLocation>();
            JsonArray dimensionsJson = serializedRecipe.getAsJsonArray("dimensions");
            for (JsonElement dimension : dimensionsJson) {
                dimensions.add(new ResourceLocation(dimension.getAsString()));
            }
            return new FireCraftingRecipe(recipeId, lootTable, maxItemDrops, baseBlocks, baseTags, dimensions);
        }

        public FireCraftingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            try {
                ResourceLocation lootTable = buffer.m_130281_();
                int maxItemDrops = buffer.readInt();
                List baseBlocks = buffer.m_236845_(buf -> (Block)ForgeRegistries.BLOCKS.getValue(buf.m_130281_()));
                List baseTags = buffer.m_236845_(buf -> BlockTags.create((ResourceLocation)buf.m_130281_()));
                List dimensions = buffer.m_236845_(FriendlyByteBuf::m_130281_);
                return new FireCraftingRecipe(recipeId, lootTable, maxItemDrops, baseBlocks, baseTags, dimensions);
            }
            catch (Exception e) {
                EnderIO.LOGGER.error("Error reading fire crafting recipe from packet.", (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(FriendlyByteBuf buffer, FireCraftingRecipe recipe) {
            try {
                buffer.m_130085_(recipe.lootTable);
                buffer.writeInt(recipe.maxItemDrops);
                buffer.m_236828_(recipe.bases, (buf, block) -> buf.m_130085_(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey(block))));
                buffer.m_236828_(recipe.baseTags, (buf, tag) -> buf.m_130085_(tag.f_203868_()));
                buffer.m_236828_(recipe.dimensions, FriendlyByteBuf::m_130085_);
            }
            catch (Exception ex) {
                EnderIO.LOGGER.error("Error writing fire crafting recipe to packet.", (Throwable)ex);
                throw ex;
            }
        }
    }
}

