/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.client.renderer.travel;

import com.enderio.api.travel.ITravelTarget;
import com.enderio.api.travel.TravelRegistry;
import com.enderio.base.common.handler.TravelHandler;
import com.enderio.base.common.travel.TravelSavedData;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Position;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class RenderTravelTargets {
    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (level == null || player == null || event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            return;
        }
        if (!TravelHandler.canTeleport((Player)player)) {
            return;
        }
        boolean itemTeleport = TravelHandler.canItemTeleport((Player)player);
        TravelSavedData data = TravelSavedData.getTravelData((Level)Minecraft.m_91087_().f_91073_);
        @Nullable ITravelTarget activeTarget = TravelHandler.getTeleportAnchorTarget((Player)player).orElse(null);
        for (ITravelTarget target : data.getTravelTargets()) {
            double distanceSquared;
            double range = itemTeleport ? (double)target.getItem2BlockRange() : (double)target.getBlock2BlockRange();
            if (range * range < (distanceSquared = target.getPos().m_203193_((Position)player.m_20182_())) || distanceSquared < 25.0 || TravelHandler.isTeleportPositionClear((BlockGetter)level, target.getPos()).isEmpty()) continue;
            PoseStack poseStack = event.getPoseStack();
            poseStack.m_85836_();
            Camera mainCamera = Minecraft.m_91087_().f_91063_.m_109153_();
            Vec3 projectedView = mainCamera.m_90583_();
            poseStack.m_85837_(-projectedView.f_82479_, -projectedView.f_82480_, -projectedView.f_82481_);
            boolean active = activeTarget == target;
            TravelRegistry.getRenderer(target).render(target, event.getLevelRenderer(), poseStack, distanceSquared, active);
            poseStack.m_85849_();
        }
    }
}

