/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.feature.client.layer;

import com.blakebr0.pickletweaks.compat.curios.CuriosCompat;
import com.blakebr0.pickletweaks.init.ModItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class NightVisionGogglesRenderLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation TEXTURE_BASIC = new ResourceLocation("pickletweaks", "textures/models/armor/night_vision_goggles_layer_1.png");
    private static final ResourceLocation TEXTURE_REINFORCED = new ResourceLocation("pickletweaks", "textures/models/armor/reinforced_night_vision_goggles_layer_1.png");

    public NightVisionGogglesRenderLayer(RenderLayerParent<T, M> parent) {
        super(parent);
    }

    public void render(PoseStack matrix, MultiBufferSource buffer, int lightness, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CuriosCompat.findNightVisionGogglesCurio(entity).ifPresent(curio -> {
            HumanoidModel model = IClientItemExtensions.of((ItemStack)curio).getHumanoidArmorModel(entity, curio, EquipmentSlot.CHEST, null);
            ResourceLocation texture = curio.m_150930_((Item)ModItems.NIGHT_VISION_GOGGLES.get()) ? TEXTURE_BASIC : TEXTURE_REINFORCED;
            ((HumanoidModel)this.m_117386_()).m_102872_(model);
            this.renderModel(matrix, buffer, lightness, curio.m_41790_(), (Model)model, 1.0f, 1.0f, 1.0f, texture);
        });
    }

    private void renderModel(PoseStack matrix, MultiBufferSource buffer, int lightness, boolean foil, Model model, float r, float g, float b, ResourceLocation armorResource) {
        VertexConsumer vertex = ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)RenderType.m_110431_((ResourceLocation)armorResource), (boolean)false, (boolean)foil);
        model.m_7695_(matrix, vertex, lightness, OverlayTexture.f_118083_, r, g, b, 1.0f);
    }
}

