/*
 * Decompiled with CFR 0.152.
 */
package commoble.hyperbox.dimension;

import commoble.hyperbox.dimension.TeleportHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;

public class DelayedTeleportData
extends SavedData {
    public static final String DATA_KEY = "hyperbox:delayed_events";
    private List<TeleportEntry> delayedTeleports = new ArrayList<TeleportEntry>();

    public static DelayedTeleportData getOrCreate(ServerLevel level) {
        return (DelayedTeleportData)level.m_8895_().m_164861_(DelayedTeleportData::load, DelayedTeleportData::create, DATA_KEY);
    }

    public static DelayedTeleportData load(CompoundTag nbt) {
        return DelayedTeleportData.create();
    }

    public static DelayedTeleportData create() {
        return new DelayedTeleportData();
    }

    protected DelayedTeleportData() {
    }

    public static void tick(ServerLevel level) {
        MinecraftServer server = level.m_7654_();
        DelayedTeleportData eventData = DelayedTeleportData.getOrCreate(level);
        List<TeleportEntry> teleports = eventData.delayedTeleports;
        eventData.delayedTeleports = new ArrayList<TeleportEntry>();
        for (TeleportEntry entry : teleports) {
            ServerPlayer player = server.m_6846_().m_11259_(entry.playerUUID);
            ServerLevel targetWorld = server.m_129880_(entry.targetLevel);
            if (player == null || targetWorld == null || player.m_9236_() != level) continue;
            TeleportHelper.sendPlayerToDimension(player, targetWorld, entry.targetVec);
        }
    }

    public void schedulePlayerTeleport(Player player, ResourceKey<Level> destination, Vec3 targetVec) {
        this.delayedTeleports.add(new TeleportEntry(player.m_36316_().getId(), destination, targetVec));
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        return compound;
    }

    private record TeleportEntry(UUID playerUUID, ResourceKey<Level> targetLevel, Vec3 targetVec) {
    }
}

