/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.datagen.recipe.combiner;

import com.smashingmods.alchemistry.datagen.recipe.combiner.CombinerRecipeResult;
import com.smashingmods.alchemylib.api.item.IngredientStack;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class CombinerRecipeBuilder
implements RecipeBuilder {
    private String group;
    private final ResourceLocation recipeId;
    private final Set<IngredientStack> input;
    private final ItemStack result;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();

    public CombinerRecipeBuilder(ItemStack pOutput, List<IngredientStack> pInput, ResourceLocation pRecipeId) {
        this.result = pOutput;
        this.input = new HashSet<IngredientStack>(pInput);
        this.recipeId = pRecipeId;
    }

    public static CombinerRecipeBuilder createRecipe(ItemStack pOutput, List<IngredientStack> pInput, ResourceLocation pRecipeId) {
        return new CombinerRecipeBuilder(pOutput, pInput, pRecipeId);
    }

    public RecipeBuilder m_126132_(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancementBuilder.m_138386_(pCriterionName, pCriterionTrigger).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)this.recipeId)).m_138360_(RequirementsStrategy.f_15979_);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public Item m_142372_() {
        return this.result.m_41720_();
    }

    public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        String advancementPath = String.format("recipes/combiner/%s", pRecipeId.m_135815_());
        ResourceLocation recipeLocation = new ResourceLocation("alchemistry", String.format("combiner/%s", pRecipeId.m_135815_()));
        ResourceLocation advancementLocation = new ResourceLocation("alchemistry", advancementPath);
        pFinishedRecipeConsumer.accept(new CombinerRecipeResult(this.group, this.advancementBuilder, recipeLocation, advancementLocation, this.input, this.result));
    }
}

