/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.datagen.recipe;

import com.smashingmods.chemlib.registry.ItemRegistry;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class RecipeUtils {
    public static ItemStack toStack(String pString) {
        return RecipeUtils.toStack(pString, 1);
    }

    public static ItemStack toStack(String pString, int pCount) {
        ResourceLocation resourceLocation = new ResourceLocation(pString);
        Optional optionalElement = ItemRegistry.getElementByName((String)pString);
        Optional optionalCompound = ItemRegistry.getCompoundByName((String)pString.replace(" ", "_"));
        Item outputItem = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
        Block outputBlock = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
        if (optionalElement.isPresent()) {
            return new ItemStack((ItemLike)optionalElement.get(), pCount);
        }
        if (optionalCompound.isPresent()) {
            return new ItemStack((ItemLike)optionalCompound.get(), pCount);
        }
        if (outputItem != null) {
            return new ItemStack((ItemLike)outputItem, pCount);
        }
        if (outputBlock != null && outputBlock != Blocks.f_50016_ && outputBlock != Blocks.f_49990_) {
            return new ItemStack((ItemLike)outputBlock, pCount);
        }
        return ItemStack.f_41583_;
    }

    public static ResourceLocation getLocation(ItemStack pItemStack, String pType) {
        return RecipeUtils.getLocation(pItemStack.m_41720_(), pType);
    }

    public static ResourceLocation getLocation(Item pItem, String pType) {
        return new ResourceLocation("alchemistry", String.format("%s/%s", pType, Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)pItem)).m_135815_()));
    }

    public static ResourceLocation getLocation(FluidStack pFluidStack, String pType) {
        return new ResourceLocation("alchemistry", String.format("%s/%s", pType, Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)pFluidStack.getFluid())).m_135815_()));
    }
}

