/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.recipe.dissolver;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ProbabilityGroup {
    private final List<ItemStack> output;
    private final double probability;

    public ProbabilityGroup(List<ItemStack> pOutput, double pProbability) {
        this.output = pOutput;
        this.probability = pProbability;
    }

    public ProbabilityGroup(List<ItemStack> pOutput) {
        this.output = pOutput;
        this.probability = 100.0;
    }

    public List<ItemStack> getOutput() {
        return this.output;
    }

    public double getProbability() {
        return this.probability;
    }

    public JsonElement serialize() {
        JsonObject output = new JsonObject();
        output.add("probability", (JsonElement)new JsonPrimitive((Number)this.probability));
        JsonArray results = new JsonArray();
        for (ItemStack itemStack : this.output) {
            JsonObject jsonObject;
            int count;
            for (count = itemStack.m_41613_(); count > 64; count -= 64) {
                jsonObject = new JsonObject();
                jsonObject.add("item", (JsonElement)new JsonPrimitive(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_())).toString()));
                jsonObject.add("count", (JsonElement)new JsonPrimitive((Number)64));
                results.add((JsonElement)jsonObject);
            }
            jsonObject = new JsonObject();
            jsonObject.add("item", (JsonElement)new JsonPrimitive(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_())).toString()));
            if (count > 1) {
                jsonObject.add("count", (JsonElement)new JsonPrimitive((Number)count));
            }
            results.add((JsonElement)jsonObject);
        }
        output.add("results", (JsonElement)results);
        return output;
    }

    public void toNetwork(FriendlyByteBuf buf) {
        buf.writeInt(this.output.size());
        for (ItemStack stack : this.output) {
            buf.writeItemStack(stack, false);
        }
        buf.writeDouble(this.probability);
    }

    public static ProbabilityGroup fromNetwork(FriendlyByteBuf buf) {
        ArrayList stacks = Lists.newArrayList();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            stacks.add(buf.m_130267_());
        }
        double probability = buf.readDouble();
        return new ProbabilityGroup(stacks, probability);
    }
}

