/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.block.reactor;

import com.smashingmods.alchemistry.common.block.reactor.AbstractReactorBlockEntity;
import com.smashingmods.alchemistry.registry.BlockEntityRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class ReactorOutputBlockEntity
extends BlockEntity {
    @Nullable
    private AbstractReactorBlockEntity controller;
    private LazyOptional<IItemHandler> lazyOutputHandler;

    public ReactorOutputBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityRegistry.REACTOR_OUTPUT_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
    }

    @Nullable
    public AbstractReactorBlockEntity getController() {
        return this.controller;
    }

    public void setController(@Nullable AbstractReactorBlockEntity pController) {
        if (this.controller == pController) {
            return;
        }
        this.controller = pController;
        this.lazyOutputHandler = LazyOptional.of(() -> this.controller.getOutputHandler());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> pCapability, @Nullable Direction pDirection) {
        if (pCapability == ForgeCapabilities.ITEM_HANDLER) {
            if (this.controller != null) {
                return this.lazyOutputHandler.cast();
            }
            return LazyOptional.empty();
        }
        return super.getCapability(pCapability, pDirection);
    }
}

