/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.block.combiner;

import com.smashingmods.alchemistry.client.container.RecipeSelectorScreen;
import com.smashingmods.alchemistry.client.container.SideModeScreen;
import com.smashingmods.alchemistry.common.block.combiner.CombinerBlockEntity;
import com.smashingmods.alchemistry.common.block.combiner.CombinerMenu;
import com.smashingmods.alchemistry.common.recipe.combiner.CombinerRecipe;
import com.smashingmods.alchemistry.registry.RecipeRegistry;
import com.smashingmods.alchemylib.api.blockentity.container.AbstractProcessingMenu;
import com.smashingmods.alchemylib.api.blockentity.container.AbstractProcessingScreen;
import com.smashingmods.alchemylib.api.blockentity.container.Direction2D;
import com.smashingmods.alchemylib.api.blockentity.container.FakeItemRenderer;
import com.smashingmods.alchemylib.api.blockentity.container.data.AbstractDisplayData;
import com.smashingmods.alchemylib.api.blockentity.container.data.EnergyDisplayData;
import com.smashingmods.alchemylib.api.blockentity.container.data.ProgressDisplayData;
import com.smashingmods.alchemylib.api.item.IngredientStack;
import com.smashingmods.alchemylib.api.storage.ProcessingSlotHandler;
import com.smashingmods.alchemylib.client.button.LockButton;
import com.smashingmods.alchemylib.client.button.PauseButton;
import com.smashingmods.alchemylib.client.button.RecipeSelectorButton;
import com.smashingmods.alchemylib.client.button.SideModeButton;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class CombinerScreen
extends AbstractProcessingScreen<CombinerMenu> {
    protected final List<AbstractDisplayData> displayData = new ArrayList<AbstractDisplayData>();
    private final CombinerBlockEntity blockEntity;
    private final LockButton lockButton = new LockButton((AbstractProcessingScreen)this);
    private final PauseButton pauseButton = new PauseButton((AbstractProcessingScreen)this);
    private final SideModeButton sideModeButton;
    private final RecipeSelectorScreen<CombinerScreen, CombinerBlockEntity, CombinerRecipe> recipeSelectorScreen;
    private final RecipeSelectorButton recipeSelector;

    public CombinerScreen(CombinerMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractProcessingMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 184;
        this.f_97727_ = 193;
        this.displayData.add((AbstractDisplayData)new ProgressDisplayData(pMenu.getBlockEntity(), 87, 35, 60, 9, Direction2D.RIGHT));
        this.displayData.add((AbstractDisplayData)new EnergyDisplayData(pMenu.getBlockEntity(), 12, 12, 16, 54));
        this.blockEntity = (CombinerBlockEntity)pMenu.getBlockEntity();
        SideModeScreen<CombinerScreen> sideModeScreen = new SideModeScreen<CombinerScreen>(this);
        this.sideModeButton = new SideModeButton((AbstractProcessingScreen)this, sideModeScreen);
        this.recipeSelectorScreen = new RecipeSelectorScreen<CombinerScreen, CombinerBlockEntity, CombinerRecipe>(this, (CombinerBlockEntity)((CombinerMenu)this.m_6262_()).getBlockEntity(), RecipeRegistry.getCombinerRecipes(pMenu.getLevel()));
        this.recipeSelector = new RecipeSelectorButton((AbstractProcessingScreen)this, this.recipeSelectorScreen);
    }

    protected void m_7856_() {
        this.recipeSelectorScreen.setTopPos((this.f_96544_ - this.f_97727_) / 2);
        this.widgets.add(this.lockButton);
        this.widgets.add(this.pauseButton);
        this.widgets.add(this.recipeSelector);
        this.widgets.add(this.sideModeButton);
        super.m_7856_();
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderDisplayData(this.displayData, pGuiGraphics, this.f_97735_, this.f_97736_);
        this.renderCurrentRecipe(pGuiGraphics, pMouseX, pMouseY);
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
        this.renderDisplayTooltip(this.displayData, pGuiGraphics, this.f_97735_, this.f_97736_, pMouseX, pMouseY);
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        pGuiGraphics.m_280218_(new ResourceLocation("alchemistry", "textures/gui/combiner_gui.png"), this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        MutableComponent title = MutableComponent.m_237204_((ComponentContents)new TranslatableContents("alchemistry.container.combiner", null, TranslatableContents.f_237494_));
        pGuiGraphics.m_280430_(this.f_96547_, (Component)title, this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)title) / 2, -10, -1);
    }

    private void renderCurrentRecipe(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        CombinerRecipe currentRecipe = (CombinerRecipe)((CombinerMenu)this.f_97732_).getBlockEntity().getRecipe();
        ProcessingSlotHandler handler = this.blockEntity.getInputHandler();
        if (currentRecipe != null) {
            ItemStack currentOutput = currentRecipe.getOutput();
            pGuiGraphics.m_280480_(currentOutput, this.f_97735_ + 152, this.f_97736_ + 15);
            if (pMouseX >= this.f_97735_ + 149 && pMouseX < this.f_97735_ + 173 && pMouseY >= this.f_97736_ + 11 && pMouseY < this.f_97736_ + 35) {
                this.renderItemTooltip(pGuiGraphics, currentOutput, MutableComponent.m_237204_((ComponentContents)new TranslatableContents("alchemistry.container.current_recipe", "Current recipe:", TranslatableContents.f_237494_)), pMouseX, pMouseY);
            }
            int xOrigin = this.f_97735_ + 48;
            int yOrigin = this.f_97736_ + 22;
            for (int row = 0; row < 2; ++row) {
                for (int column = 0; column < 2; ++column) {
                    int index = column + row * 2;
                    int x = xOrigin + column * 18;
                    int y = yOrigin + row * 18;
                    if (index >= currentRecipe.getInput().size()) continue;
                    ItemStack itemStack = ((IngredientStack)currentRecipe.getInput().get(index)).getIngredient().m_43908_()[(int)(Math.random() * (double)((IngredientStack)currentRecipe.getInput().get(index)).getIngredient().m_43908_().length)];
                    boolean required = handler.getStacks().stream().noneMatch(handlerItem -> {
                        boolean sameItem = ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)handlerItem);
                        boolean minCount = handlerItem.m_41613_() >= itemStack.m_41613_();
                        return sameItem && minCount;
                    });
                    if (!handler.getStackInSlot(index).m_41619_() || !required) continue;
                    FakeItemRenderer.renderFakeItem((GuiGraphics)pGuiGraphics, (ItemStack)itemStack, (int)x, (int)y, (boolean)true);
                    if (pMouseX < x - 2 || pMouseX >= x + 16 || pMouseY < y - 1 || pMouseY >= y + 17) continue;
                    this.renderItemTooltip(pGuiGraphics, itemStack, MutableComponent.m_237204_((ComponentContents)new TranslatableContents("alchemistry.container.required_input", "Required input item:", TranslatableContents.f_237494_)), pMouseX, pMouseY);
                }
            }
        }
    }
}

