/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.menu;

import com.mrbysco.forcecraft.items.ItemCardItem;
import com.mrbysco.forcecraft.registry.ForceMenus;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public class ItemCardMenu
extends AbstractContainerMenu {
    private final CraftingContainer craftMatrix = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
    private final ResultContainer craftResult = new ResultContainer();
    private final ContainerLevelAccess worldPosCallable;
    private final Player player;
    private ItemStack heldStack;

    public ItemCardMenu(int id, Inventory playerInventory) {
        this(id, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public ItemCardMenu(int id, Inventory playerInventory, ContainerLevelAccess worldPosCallable) {
        super((MenuType)ForceMenus.ITEM_CARD.get(), id);
        CompoundTag tag;
        this.worldPosCallable = worldPosCallable;
        this.player = playerInventory.f_35978_;
        this.m_38897_((Slot)new ResultSlot(playerInventory.f_35978_, this.craftMatrix, (Container)this.craftResult, 0, 124, 35){

            public boolean m_8010_(Player playerIn) {
                return false;
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.m_38897_(new Slot((Container)this.craftMatrix, j + i * 3, 30 + j * 18, 17 + i * 18){

                    public int m_6641_() {
                        return 1;
                    }

                    @Nonnull
                    public void m_142406_(Player player, @Nonnull ItemStack stack) {
                    }

                    @Nonnull
                    public ItemStack m_6201_(int par1) {
                        return ItemStack.f_41583_;
                    }

                    public boolean m_5857_(ItemStack par1ItemStack) {
                        return false;
                    }

                    public boolean m_8010_(Player par1PlayerEntity) {
                        return false;
                    }
                });
            }
        }
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.m_38897_(new Slot((Container)playerInventory, i1 + k * 9 + 9, 8 + i1 * 18, 84 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.m_38897_(new Slot((Container)playerInventory, l, 8 + l * 18, 142));
        }
        this.heldStack = ItemCardMenu.getCardStack(playerInventory);
        if (this.heldStack.m_41720_() == ForceRegistry.ITEM_CARD.get() && (tag = this.heldStack.m_41784_()).m_128441_("RecipeContents")) {
            CompoundTag recipeContents = tag.m_128469_("RecipeContents");
            if (!this.player.m_9236_().f_46443_) {
                for (int i = 0; i < this.craftMatrix.m_6643_(); ++i) {
                    this.craftMatrix.m_6836_(i, ItemStack.m_41712_((CompoundTag)recipeContents.m_128469_("slot_" + i)));
                }
                this.craftResult.m_6836_(0, ItemStack.m_41712_((CompoundTag)recipeContents.m_128469_("result")));
            }
        }
    }

    public static ItemStack getCardStack(Inventory playerInventory) {
        Player player = playerInventory.f_35978_;
        if (player.m_21205_().m_41720_() instanceof ItemCardItem) {
            return player.m_21205_();
        }
        if (player.m_21206_().m_41720_() instanceof ItemCardItem) {
            return player.m_21206_();
        }
        return ItemStack.f_41583_;
    }

    protected void updateCraftingResult(Level level, Player player, CraftingContainer inventory, ResultContainer inventoryResult) {
        if (!level.f_46443_) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Optional iRecipe = serverPlayer.f_8924_.m_129894_().m_44015_(RecipeType.f_44107_, (Container)inventory, level);
            if (iRecipe.isPresent() && (((CraftingRecipe)iRecipe.get()).m_5598_() || !level.m_46469_().m_46207_(GameRules.f_46151_) || serverPlayer.m_8952_().m_12709_((Recipe)iRecipe.get()) || player.m_7500_())) {
                ItemStack stack = ((CraftingRecipe)iRecipe.get()).m_5874_((Container)this.craftMatrix, level.m_9598_());
                inventoryResult.m_6836_(0, stack);
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.f_38840_, 0, 0, stack));
            } else {
                inventoryResult.m_6836_(0, ItemStack.f_41583_);
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.f_38840_, 0, 0, ItemStack.f_41583_));
            }
        }
    }

    public void m_6199_(Container inventoryIn) {
        this.worldPosCallable.m_39292_((world, pos) -> this.updateCraftingResult((Level)world, this.player, this.craftMatrix, this.craftResult));
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
    }

    public boolean m_6875_(Player playerIn) {
        return !this.heldStack.m_41619_();
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        int total_crafting_slots = 10;
        if (index <= 10) {
            return ItemStack.f_41583_;
        }
        int total_slots = 46;
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == 0) {
                if (!this.m_38903_(itemstack1, 10, 46, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (index < 32 ? !this.m_38903_(itemstack1, 32, 46, false) : index < 46 && !this.m_38903_(itemstack1, 10, 32, false) || !this.m_38903_(itemstack1, 10, 46, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
        }
        return itemstack;
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId >= 1 && slotId < 10) {
            if (clickTypeIn == ClickType.PICKUP || clickTypeIn == ClickType.PICKUP_ALL || clickTypeIn == ClickType.SWAP) {
                Slot slot = (Slot)this.f_38839_.get(slotId);
                ItemStack dropping = this.m_142621_();
                this.handleSlotClick(slot, dropping);
                return;
            }
            return;
        }
        if (clickTypeIn == ClickType.QUICK_MOVE) {
            return;
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    public ItemStack handleSlotClick(Slot slotId, ItemStack stack) {
        if (stack.m_41613_() > 0) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            slotId.m_5852_(copy);
        } else if (slotId.m_7993_().m_41613_() > 0) {
            slotId.m_5852_(ItemStack.f_41583_);
        }
        return slotId.m_7993_().m_41777_();
    }

    public boolean m_5882_(ItemStack stack, Slot slotIn) {
        return slotIn.f_40218_ != this.craftResult && super.m_5882_(stack, slotIn);
    }

    public CraftingContainer getCraftMatrix() {
        return this.craftMatrix;
    }

    public ResultContainer getCraftResult() {
        return this.craftResult;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setMatrixContents(Player player, List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            this.handleSlotClick(this.m_38853_(i), stacks.get(i));
        }
    }

    public List<ItemStack> getMatrixContents() {
        return null;
    }
}

