/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.tools;

import com.mrbysco.forcecraft.ForceCraft;
import com.mrbysco.forcecraft.capabilities.CapabilityHandler;
import com.mrbysco.forcecraft.capabilities.forcewrench.ForceWrenchCapability;
import com.mrbysco.forcecraft.capabilities.forcewrench.IForceWrench;
import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.items.infuser.ForceToolData;
import com.mrbysco.forcecraft.items.infuser.IForceChargingTool;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;

public class ForceWrenchItem
extends BaseItem
implements IForceChargingTool {
    public ForceWrenchItem(Item.Properties name) {
        super(name.m_41487_(1));
    }

    public void m_7836_(ItemStack stack, Level level, Player player) {
        super.m_7836_(stack, level, player);
        this.initializeTag(stack);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, level, entityIn, itemSlot, isSelected);
        if (stack.m_41783_() == null) {
            this.initializeTag(stack);
        }
    }

    private void initializeTag(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_("ForceInfused", false);
        stack.m_41751_(tag);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        InteractionHand hand = context.m_43724_();
        if (stack.m_41720_() instanceof ForceWrenchItem) {
            if (player.m_6047_()) {
                IForceWrench wrenchCap = (IForceWrench)stack.getCapability(CapabilityHandler.CAPABILITY_FORCEWRENCH).orElse(null);
                if (wrenchCap != null) {
                    if (level.m_7702_(pos) instanceof BlockEntity && !wrenchCap.canStoreBlock()) {
                        return this.serializeNBT(level, pos, player, hand);
                    }
                    if (wrenchCap.canStoreBlock()) {
                        this.placeBlockFromWrench(level, pos, player, hand, context.m_43719_());
                    }
                }
            } else {
                ForceToolData fd = new ForceToolData(stack);
                if (fd.getForce() >= 10) {
                    BlockState state = level.m_8055_(pos);
                    if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                        level.m_46597_(pos, state.rotate((LevelAccessor)level, pos, Rotation.CLOCKWISE_90));
                        fd.setForce(fd.getForce() - 10);
                        fd.write(stack);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237110_((String)"forcecraft.wrench_rotate.insufficient", (Object[])new Object[]{10}).m_130940_(ChatFormatting.RED), true);
                }
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (CapabilityHandler.CAPABILITY_FORCEWRENCH == null) {
            return null;
        }
        return new ForceWrenchCapability();
    }

    private InteractionResult serializeNBT(Level level, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack heldWrench = player.m_21120_(hand);
        ForceToolData fd = new ForceToolData(heldWrench);
        if (fd.getForce() >= 250) {
            BlockState state = level.m_8055_(pos);
            if (state.m_60811_() == PushReaction.BLOCK) {
                return InteractionResult.FAIL;
            }
            IForceWrench wrenchCap = (IForceWrench)heldWrench.getCapability(CapabilityHandler.CAPABILITY_FORCEWRENCH).orElse(null);
            if (wrenchCap != null) {
                String blockName = state.m_60734_().m_7705_();
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity != null) {
                    CompoundTag nbt = blockEntity.m_187482_();
                    wrenchCap.storeBlockNBT(nbt);
                    wrenchCap.storeBlockState(state);
                    wrenchCap.setBlockName(blockName);
                    level.m_46747_(pos);
                }
                fd.setForce(fd.getForce() - 250);
                fd.write(heldWrench);
                BlockState airState = Blocks.f_50016_.m_49966_();
                level.m_46597_(pos, airState);
                return InteractionResult.SUCCESS;
            }
        } else {
            player.m_5661_((Component)Component.m_237110_((String)"forcecraft.wrench_transport.insufficient", (Object[])new Object[]{250}).m_130940_(ChatFormatting.RED), true);
        }
        return InteractionResult.FAIL;
    }

    private InteractionResult placeBlockFromWrench(Level level, BlockPos pos, Player player, InteractionHand hand, Direction side) {
        ItemStack heldWrench = player.m_21120_(hand);
        IForceWrench wrenchCap = (IForceWrench)heldWrench.getCapability(CapabilityHandler.CAPABILITY_FORCEWRENCH).orElse(null);
        if (wrenchCap != null && wrenchCap.getStoredBlockState() != null) {
            Block block;
            BlockState state = wrenchCap.getStoredBlockState();
            BlockPos offPos = pos.m_121945_(side);
            if (state != null) {
                level.m_46597_(offPos, state);
            }
            if (wrenchCap.getStoredBlockNBT() != null && (block = state.m_60734_()) instanceof EntityBlock) {
                EntityBlock entityBlock = (EntityBlock)block;
                CompoundTag blockTag = wrenchCap.getStoredBlockNBT();
                BlockEntity be = entityBlock.m_142194_(offPos, state);
                if (be != null) {
                    be.m_142466_(blockTag);
                    be.m_6596_();
                    level.m_151523_(be);
                    level.m_151543_(offPos);
                } else if (blockTag != null) {
                    ForceCraft.LOGGER.error("Was unable to load block entity");
                }
            }
            wrenchCap.clearBlockStorage();
        }
        return InteractionResult.SUCCESS;
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag nbt = super.getShareTag(stack);
        IForceWrench cap = (IForceWrench)stack.getCapability(CapabilityHandler.CAPABILITY_FORCEWRENCH).orElse(null);
        if (cap != null) {
            CompoundTag shareTag = ForceWrenchCapability.writeNBT(cap);
            if (nbt == null) {
                nbt = new CompoundTag();
            }
            nbt.m_128365_("forcecraft", (Tag)shareTag);
        }
        return nbt;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt == null || !nbt.m_128441_("forcecraft")) {
            return;
        }
        IForceWrench cap = (IForceWrench)stack.getCapability(CapabilityHandler.CAPABILITY_FORCEWRENCH).orElse(null);
        if (cap != null) {
            CompoundTag shareTag = nbt.m_128469_("forcecraft");
            ForceWrenchCapability.readNBT(cap, shareTag);
        }
        super.readShareTag(stack, nbt);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> lores, TooltipFlag flagIn) {
        ForceWrenchCapability.attachInformation(stack, lores);
        super.m_7373_(stack, level, lores, flagIn);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return this.damageItem(stack, amount);
    }
}

