/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items.tools;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.mrbysco.forcecraft.networking.PacketHandler;
import com.mrbysco.forcecraft.registry.ForceSounds;
import com.mrbysco.forcecraft.registry.ForceTags;
import com.mrbysco.forcecraft.registry.material.ModToolTiers;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolActions;

public class ForceMittItem
extends DiggerItem {
    private final float attackDamage;
    private final Tier itemTier = ModToolTiers.FORCE;

    public ForceMittItem(Item.Properties properties) {
        super(8.0f, 8.0f, ModToolTiers.FORCE, ForceTags.MINEABLE_WITH_MITTS, properties.m_41503_(1000));
        this.attackDamage = 3.0f;
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            if (state.m_204336_(BlockTags.f_13035_)) {
                BlockHitResult traceResult = ForceMittItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
                switch (traceResult.m_82434_().m_122434_()) {
                    case X: {
                        this.breakBlockAt(player, level, stack, pos.m_7494_());
                        this.breakBlockAt(player, level, stack, pos.m_7495_());
                        this.breakBlockAt(player, level, stack, pos.m_122012_());
                        this.breakBlockAt(player, level, stack, pos.m_122012_().m_7494_());
                        this.breakBlockAt(player, level, stack, pos.m_122012_().m_7495_());
                        this.breakBlockAt(player, level, stack, pos.m_122019_());
                        this.breakBlockAt(player, level, stack, pos.m_122019_().m_7494_());
                        this.breakBlockAt(player, level, stack, pos.m_122019_().m_7495_());
                        break;
                    }
                    case Z: {
                        this.breakBlockAt(player, level, stack, pos.m_7494_());
                        this.breakBlockAt(player, level, stack, pos.m_7495_());
                        this.breakBlockAt(player, level, stack, pos.m_122024_());
                        this.breakBlockAt(player, level, stack, pos.m_122024_().m_7494_());
                        this.breakBlockAt(player, level, stack, pos.m_122024_().m_7495_());
                        this.breakBlockAt(player, level, stack, pos.m_122029_());
                        this.breakBlockAt(player, level, stack, pos.m_122029_().m_7494_());
                        this.breakBlockAt(player, level, stack, pos.m_122029_().m_7495_());
                        break;
                    }
                    case Y: {
                        this.breakBlockAt(player, level, stack, pos.m_122012_());
                        this.breakBlockAt(player, level, stack, pos.m_122029_());
                        this.breakBlockAt(player, level, stack, pos.m_122024_());
                        this.breakBlockAt(player, level, stack, pos.m_122024_().m_122012_());
                        this.breakBlockAt(player, level, stack, pos.m_122024_().m_122029_());
                        this.breakBlockAt(player, level, stack, pos.m_122029_());
                        this.breakBlockAt(player, level, stack, pos.m_122029_().m_122012_());
                        this.breakBlockAt(player, level, stack, pos.m_122029_().m_122029_());
                    }
                }
                level.m_5594_((Player)null, pos, (SoundEvent)ForceSounds.WHOOSH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        return super.m_6813_(stack, level, state, pos, entityLiving);
    }

    public void breakBlockAt(Player player, Level level, ItemStack stack, BlockPos pos) {
        BlockEntity tileEntity = level.m_7702_(pos);
        if (level.m_8055_(pos).m_204336_(BlockTags.f_13035_)) {
            BlockState state = level.m_8055_(pos);
            if (!ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player)) {
                return;
            }
            if (!level.f_46443_) {
                int xp = ForgeHooks.onBlockBreakEvent((Level)level, (GameType)((ServerPlayer)player).f_8941_.m_9290_(), (ServerPlayer)((ServerPlayer)player), (BlockPos)pos);
                if (xp == -1) {
                    return;
                }
                FluidState fluidState = level.m_6425_(pos);
                Block block = state.m_60734_();
                if (block.onDestroyedByPlayer(state, level, pos, player, true, fluidState)) {
                    block.m_5707_(level, pos, state, player);
                    block.m_6240_(level, player, pos, state, tileEntity, stack);
                    block.m_49805_((ServerLevel)level, pos, xp);
                }
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123766_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 1, 0.0, 0.0, 0.0, 0.0);
                PacketHandler.sendPacket((Entity)player, new ClientboundBlockUpdatePacket((BlockGetter)level, pos));
            }
        }
    }

    public int m_6473_() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        BlockState blockstate = level.m_8055_(blockpos);
        Player player = context.m_43723_();
        ItemStack itemstack = context.m_43722_();
        Pair pair = (Pair)HoeItem.f_41332_.get(level.m_8055_(blockpos).m_60734_());
        if (context.m_43719_() != Direction.DOWN && level.m_46859_(blockpos.m_7494_())) {
            if (pair == null) {
                return InteractionResult.PASS;
            }
            Predicate predicate = (Predicate)pair.getFirst();
            Consumer consumer = (Consumer)pair.getSecond();
            if (predicate.test(context)) {
                level.m_5594_(player, blockpos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!level.f_46443_) {
                    consumer.accept(context);
                    if (player != null) {
                        context.m_43722_().m_41622_(1, (LivingEntity)player, p_150845_ -> p_150845_.m_21190_(context.m_43724_()));
                    }
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.PASS;
        }
        Optional<BlockState> optional = Optional.ofNullable(blockstate.getToolModifiedState(context, ToolActions.AXE_STRIP, false));
        if (optional.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, blockpos, itemstack);
            }
            level.m_7731_(blockpos, optional.get(), 11);
            if (player != null) {
                itemstack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(context.m_43724_()));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return state.m_204336_(this.f_40979_) ? 14.0f : 1.0f;
    }

    public float m_41008_() {
        return this.itemTier.m_6631_();
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, attackerEntity -> attackerEntity.m_21190_(InteractionHand.MAIN_HAND));
        return true;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        Multimap multimap = super.m_7167_(equipmentSlot);
        if (equipmentSlot == EquipmentSlot.MAINHAND && multimap != null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon damage modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon speed modifier", (double)-2.4f, AttributeModifier.Operation.ADDITION));
            multimap = builder.build();
        }
        return multimap;
    }
}

