/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items;

import com.mrbysco.forcecraft.client.gui.pack.RenameAndRecolorScreen;
import com.mrbysco.forcecraft.items.BaseItem;
import com.mrbysco.forcecraft.menu.ForceBeltMenu;
import com.mrbysco.forcecraft.registry.ForceTags;
import com.mrbysco.forcecraft.storage.BeltStorage;
import com.mrbysco.forcecraft.storage.StorageManager;
import com.mrbysco.forcecraft.storage.WSDCapability;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForceBeltItem
extends BaseItem {
    public ForceBeltItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player playerIn, @NotNull InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (playerIn.m_6144_()) {
            if (level.f_46443_) {
                RenameAndRecolorScreen.openScreen(stack, handIn);
            }
        } else if (!level.f_46443_) {
            BeltStorage data = StorageManager.getOrCreateBelt(stack);
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)this.getContainer(stack, data.getInventory()));
        }
        return super.m_7203_(level, playerIn, handIn);
    }

    @Nullable
    public MenuProvider getContainer(ItemStack stack, IItemHandler handler) {
        return new SimpleMenuProvider((id, inventory, player) -> new ForceBeltMenu(id, inventory, handler), (Component)(stack.m_41788_() ? ((MutableComponent)stack.m_41786_()).m_130940_(ChatFormatting.BLACK) : Component.m_237115_((String)"forcecraft.container.belt")));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("SlotsUsed") && tag.m_128441_("SlotsTotal")) {
            tooltip.add((Component)Component.m_237113_((String)String.format("%s/%s Slots", tag.m_128451_("SlotsUsed"), tag.m_128451_("SlotsTotal"))));
        } else {
            tooltip.add((Component)Component.m_237113_((String)"0/8 Slots"));
        }
        if (flagIn.m_7050_() && stack.m_41783_() != null && stack.m_41783_().m_128441_("uuid")) {
            UUID uuid = stack.m_41783_().m_128342_("uuid");
            tooltip.add((Component)Component.m_237113_((String)("ID: " + uuid.toString().substring(0, 8))).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
        super.m_7373_(stack, level, tooltip, flagIn);
    }

    public Component m_7626_(ItemStack stack) {
        return ((MutableComponent)super.m_7626_(stack)).m_130940_(ChatFormatting.YELLOW);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new WSDCapability(stack);
    }

    public static boolean filter(ItemStack stack) {
        return !(stack.m_41720_() instanceof ForceBeltItem) && stack.m_204117_(ForceTags.VALID_FORCE_BELT);
    }
}

