/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.items;

import com.mrbysco.forcecraft.capabilities.CapabilityHandler;
import com.mrbysco.forcecraft.capabilities.toolmodifier.IToolModifier;
import com.mrbysco.forcecraft.capabilities.toolmodifier.ToolModCapability;
import com.mrbysco.forcecraft.items.infuser.ForceToolData;
import com.mrbysco.forcecraft.items.infuser.IForceChargingTool;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;

public class ForceArmorItem
extends ArmorItem
implements IForceChargingTool {
    public ForceArmorItem(ArmorMaterial materialIn, ArmorItem.Type type, Item.Properties builderIn) {
        super(materialIn, type, builderIn);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (CapabilityHandler.CAPABILITY_TOOLMOD == null) {
            return null;
        }
        return new ToolModCapability();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> lores, TooltipFlag flagIn) {
        ForceToolData fd = new ForceToolData(stack);
        fd.attachInformation(lores);
        ToolModCapability.attachInformation(stack, lores);
        super.m_7373_(stack, level, lores, flagIn);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return this.damageItem(stack, amount);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        IToolModifier cap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
        if (cap != null) {
            CompoundTag shareTag = ToolModCapability.writeNBT(cap);
            nbt.m_128365_("forcecraft", (Tag)shareTag);
        }
        return nbt;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        IToolModifier cap;
        if (nbt != null && nbt.m_128441_("forcecraft") && (cap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null)) != null) {
            CompoundTag shareTag = nbt.m_128469_("forcecraft");
            ToolModCapability.readNBT(cap, shareTag);
        }
        super.readShareTag(stack, nbt);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        IToolModifier cap = (IToolModifier)stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).orElse(null);
        if (cap != null && cap.hasCamo()) {
            return "forcecraft:textures/models/armor/force_invisible.png";
        }
        return super.getArmorTexture(stack, entity, slot, type);
    }
}

