/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.entities.projectile;

import com.mrbysco.forcecraft.ForceCraft;
import com.mrbysco.forcecraft.capabilities.CapabilityHandler;
import com.mrbysco.forcecraft.registry.ForceEntities;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.util.ForceUtils;
import com.mrbysco.forcecraft.util.MobUtil;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.SwellGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class ForceArrowEntity
extends Arrow {
    private static final EntityDataAccessor<Boolean> ENDER = SynchedEntityData.m_135353_(ForceArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BANE = SynchedEntityData.m_135353_(ForceArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SPEED = SynchedEntityData.m_135353_(ForceArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> GLOWING = SynchedEntityData.m_135353_(ForceArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> LUCK = SynchedEntityData.m_135353_(ForceArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BLEEDING = SynchedEntityData.m_135353_(ForceArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ForceArrowEntity(EntityType<? extends Arrow> type, Level level) {
        super(type, level);
    }

    public ForceArrowEntity(Level level, LivingEntity shooter) {
        super(level, shooter);
        this.m_5602_((Entity)shooter);
    }

    public void m_37251_(Entity projectile, float x, float y, float z, float velocity, float inaccuracy) {
        float newVelocity = this.isSpeedy() ? velocity + 1.0f : velocity;
        super.m_37251_(projectile, x, y, z, newVelocity, inaccuracy);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ENDER, (Object)false);
        this.f_19804_.m_135372_(BANE, (Object)false);
        this.f_19804_.m_135372_(LUCK, (Object)0);
        this.f_19804_.m_135372_(BLEEDING, (Object)0);
        this.f_19804_.m_135372_(SPEED, (Object)false);
        this.f_19804_.m_135372_(GLOWING, (Object)false);
    }

    public boolean isBane() {
        return (Boolean)this.f_19804_.m_135370_(BANE);
    }

    public void setBane() {
        this.f_19804_.m_135381_(BANE, (Object)true);
    }

    public boolean isSpeedy() {
        return (Boolean)this.f_19804_.m_135370_(SPEED);
    }

    public void setSpeedy() {
        this.f_19804_.m_135381_(SPEED, (Object)true);
    }

    public boolean isEnder() {
        return (Boolean)this.f_19804_.m_135370_(ENDER);
    }

    public void setEnder() {
        this.f_19804_.m_135381_(ENDER, (Object)true);
    }

    public boolean appliesGlowing() {
        return (Boolean)this.f_19804_.m_135370_(GLOWING);
    }

    public void setAppliesGlowing() {
        this.f_19804_.m_135381_(GLOWING, (Object)true);
    }

    public int getLuck() {
        return (Integer)this.f_19804_.m_135370_(LUCK);
    }

    public void setLuck(int luck) {
        this.f_19804_.m_135381_(LUCK, (Object)luck);
    }

    public int getBleeding() {
        return (Integer)this.f_19804_.m_135370_(BLEEDING);
    }

    public void setBleeding(int bleeding) {
        this.f_19804_.m_135381_(BLEEDING, (Object)bleeding);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128471_("Bane")) {
            this.setBane();
        }
        if (compound.m_128471_("Ender")) {
            this.setEnder();
        }
        if (compound.m_128471_("AppliesGlowing")) {
            this.setAppliesGlowing();
        }
        if (compound.m_128471_("Speedy")) {
            this.setSpeedy();
        }
        this.setLuck(compound.m_128451_("Luck"));
        this.setBleeding(compound.m_128451_("Bleeding"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.isBane()) {
            compound.m_128379_("Bane", true);
        }
        if (this.isEnder()) {
            compound.m_128379_("Ender", true);
        }
        if (this.appliesGlowing()) {
            compound.m_128379_("AppliesGlowing", true);
        }
        if (this.isSpeedy()) {
            compound.m_128379_("Speedy", true);
        }
        compound.m_128405_("Luck", this.getLuck());
        compound.m_128405_("Bleeding", this.getBleeding());
    }

    public void m_36878_(ItemStack stack) {
        if (stack.m_41720_() == Items.f_42412_) {
            this.f_36855_ = Potions.f_43598_;
            this.f_36852_.clear();
            this.f_19804_.m_135381_(f_36854_, (Object)-1);
        }
    }

    protected void m_7761_(LivingEntity living) {
        super.m_7761_(living);
        if (this.isEnder()) {
            ForceUtils.teleportRandomly(living);
        }
        if (this.appliesGlowing()) {
            living.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 200, 0));
        }
        if (this.getBleeding() > 0) {
            MobUtil.addBleedingEffect(this.getBleeding(), living, this.m_19749_());
        }
        if (this.isBane() && living instanceof Creeper) {
            Creeper creeper = (Creeper)living;
            creeper.getCapability(CapabilityHandler.CAPABILITY_BANE).ifPresent(entityCap -> {
                if (entityCap.canExplode()) {
                    creeper.m_32283_(-1);
                    creeper.m_20088_().m_135381_(Creeper.f_32275_, (Object)false);
                    entityCap.setExplodeAbility(false);
                    creeper.f_21345_.f_25345_.removeIf(goal -> goal.m_26015_() instanceof SwellGoal);
                    ForceCraft.LOGGER.debug("Added Bane to " + living.m_7755_());
                }
            });
        }
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)ForceRegistry.FORCE_ARROW.get());
    }

    public EntityType<?> m_6095_() {
        return (EntityType)ForceEntities.FORCE_ARROW.get();
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

