/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.entities;

import com.mrbysco.forcecraft.entities.IColdMob;
import com.mrbysco.forcecraft.entities.goal.EatGrassToRestoreGoal;
import com.mrbysco.forcecraft.registry.ForceEntities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ColdPigEntity
extends Pig
implements IColdMob {
    private int grassTimer;
    private EatGrassToRestoreGoal eatGrassGoal;
    private ResourceLocation originalTypeLocation;

    public ColdPigEntity(EntityType<? extends Pig> type, Level level) {
        super(type, level);
        this.originalTypeLocation = new ResourceLocation("minecraft", "pig");
    }

    public ColdPigEntity(Level level, ResourceLocation typeLocation) {
        super((EntityType)ForceEntities.COLD_PIG.get(), level);
        if (typeLocation != null) {
            this.originalTypeLocation = typeLocation;
        }
    }

    public boolean m_7848_(Animal otherAnimal) {
        return false;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.originalTypeLocation = compound.m_128461_("OriginalMob").isEmpty() ? new ResourceLocation("minecraft", "pig") : new ResourceLocation(compound.m_128461_("OriginalMob"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("OriginalMob", this.originalTypeLocation.toString());
    }

    protected void m_8099_() {
        this.eatGrassGoal = new EatGrassToRestoreGoal((Mob)this);
        super.m_8099_();
        this.f_21345_.m_25352_(5, (Goal)this.eatGrassGoal);
    }

    public static AttributeSupplier.Builder generateAttributes() {
        return Pig.m_29503_();
    }

    protected void m_8024_() {
        this.grassTimer = this.eatGrassGoal.getEatingGrassTimer();
        super.m_8024_();
    }

    public void m_8107_() {
        if (this.m_9236_().f_46443_) {
            this.grassTimer = Math.max(0, this.grassTimer - 1);
        }
        super.m_8107_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 10) {
            this.grassTimer = 40;
        } else {
            super.m_7822_(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        if (this.grassTimer <= 0) {
            return 0.0f;
        }
        if (this.grassTimer >= 4 && this.grassTimer <= 36) {
            return 1.0f;
        }
        return this.grassTimer < 4 ? ((float)this.grassTimer - p_70894_1_) / 4.0f : -((float)(this.grassTimer - 40) - p_70894_1_) / 4.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.grassTimer > 4 && this.grassTimer <= 36) {
            float f = ((float)(this.grassTimer - 4) - p_70890_1_) / 32.0f;
            return 0.62831855f + 0.21991149f * Mth.m_14031_((float)(f * 28.7f));
        }
        return this.grassTimer > 0 ? 0.62831855f : this.m_146909_() * ((float)Math.PI / 180);
    }

    @Override
    public ResourceLocation getOriginal() {
        return this.originalTypeLocation;
    }
}

