/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.datagen.data.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrbysco.forcecraft.recipe.ForceRecipes;
import com.mrbysco.forcecraft.recipe.MultipleOutputFurnaceRecipe;
import com.mrbysco.forcecraft.registry.ForceRecipeSerializers;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.CraftingRecipeBuilder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultipleOutputRecipeBuilder
extends CraftingRecipeBuilder
implements RecipeBuilder {
    private final NonNullList<ItemStack> results = NonNullList.m_122779_();
    private final Ingredient ingredient;
    private final float experience;
    private final int time;
    private final float chance;
    @Nullable
    private String group;
    private final RecipeType<? extends MultipleOutputFurnaceRecipe> type;
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();

    public MultipleOutputRecipeBuilder(RecipeType<? extends MultipleOutputFurnaceRecipe> type, Ingredient ingredient, float pExperience, int grindingTime) {
        this.type = type;
        this.ingredient = ingredient;
        this.experience = pExperience;
        this.time = grindingTime;
        this.chance = 0.0f;
    }

    public MultipleOutputRecipeBuilder(RecipeType<? extends MultipleOutputFurnaceRecipe> type, Ingredient ingredient, float chance, float pExperience, int grindingTime) {
        this.type = type;
        this.ingredient = ingredient;
        this.experience = pExperience;
        this.time = grindingTime;
        this.chance = chance;
    }

    public static MultipleOutputRecipeBuilder freezing(Ingredient ingredient, float experience, int freezingTime) {
        return new MultipleOutputRecipeBuilder((RecipeType<? extends MultipleOutputFurnaceRecipe>)((RecipeType)ForceRecipes.FREEZING.get()), ingredient, experience, freezingTime);
    }

    public static MultipleOutputRecipeBuilder freezing(ItemLike input, float experience, int freezingTime) {
        return new MultipleOutputRecipeBuilder((RecipeType<? extends MultipleOutputFurnaceRecipe>)((RecipeType)ForceRecipes.FREEZING.get()), Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), experience, freezingTime);
    }

    public static MultipleOutputRecipeBuilder grinding(Ingredient ingredient, float chance, float experience, int processTime) {
        return new MultipleOutputRecipeBuilder((RecipeType<? extends MultipleOutputFurnaceRecipe>)((RecipeType)ForceRecipes.GRINDING.get()), ingredient, chance, experience, processTime);
    }

    public static MultipleOutputRecipeBuilder grinding(ItemLike input, float chance, float experience, int processTime) {
        return new MultipleOutputRecipeBuilder((RecipeType<? extends MultipleOutputFurnaceRecipe>)((RecipeType)ForceRecipes.GRINDING.get()), Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), chance, experience, processTime);
    }

    public MultipleOutputRecipeBuilder setResult(ItemLike item, int count) {
        this.results.add((Object)new ItemStack(item, count));
        return this;
    }

    public MultipleOutputRecipeBuilder setResult(ItemStack stack) {
        this.results.add((Object)stack);
        return this;
    }

    public RecipeBuilder m_126132_(String id, CriterionTriggerInstance triggerInstance) {
        this.advancement.m_138386_(id, triggerInstance);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String group) {
        this.group = group;
        return this;
    }

    public Item m_142372_() {
        return ((ItemStack)this.results.get(0)).m_41720_();
    }

    public void m_126140_(Consumer<FinishedRecipe> recipeConsumer, ResourceLocation id) {
        this.ensureValid(id);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        if (this.results.isEmpty() || this.results.size() > 2) {
            throw new IllegalStateException("Must have between 1 and 2 results.");
        }
        if (this.type == ForceRecipes.FREEZING.get()) {
            recipeConsumer.accept((FinishedRecipe)new FreezingResult(id, this.group == null ? "" : this.group, this.ingredient, this.results, this.experience, this.time, this.advancement, id.m_246208_("recipes/freezing/")));
        } else if (this.type == ForceRecipes.GRINDING.get()) {
            recipeConsumer.accept((FinishedRecipe)new GrindingResult(id, this.group == null ? "" : this.group, this.ingredient, this.results, this.chance, this.experience, this.time, this.advancement, id.m_246208_("recipes/grinding/")));
        }
    }

    private void ensureValid(ResourceLocation id) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public static class FreezingResult
    extends CraftingRecipeBuilder.CraftingResult {
        private final ResourceLocation id;
        private final String group;
        private final Ingredient ingredient;
        private final NonNullList<ItemStack> results;
        private final float experience;
        private final int time;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public FreezingResult(ResourceLocation id, String group, Ingredient ingredient, NonNullList<ItemStack> results, float experience, int time, Advancement.Builder advancement, ResourceLocation advancementId) {
            super(CraftingBookCategory.MISC);
            this.id = id;
            this.group = group;
            this.ingredient = ingredient;
            this.results = results;
            this.experience = experience;
            this.time = time;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.add("ingredient", this.ingredient.m_43942_());
            JsonArray resultsArray = new JsonArray();
            for (ItemStack result : this.results) {
                resultsArray.add(FreezingResult.serializeItemStack(result));
            }
            json.add("results", (JsonElement)resultsArray);
            json.addProperty("experience", (Number)Float.valueOf(this.experience));
            json.addProperty("processtime", (Number)this.time);
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ForceRecipeSerializers.FREEZING_SERIALIZER.get();
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }

        static JsonElement serializeItemStack(@NotNull ItemStack stack) {
            JsonObject json = new JsonObject();
            json.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString());
            if (stack.m_41613_() > 1) {
                json.addProperty("count", (Number)stack.m_41613_());
            }
            if (stack.m_41782_()) {
                json.addProperty("nbt", stack.m_41783_().toString());
            }
            return json;
        }
    }

    public static class GrindingResult
    extends CraftingRecipeBuilder.CraftingResult {
        private final ResourceLocation id;
        private final String group;
        private final Ingredient ingredient;
        private final NonNullList<ItemStack> results;
        private final float chance;
        private final float experience;
        private final int time;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public GrindingResult(ResourceLocation id, String group, Ingredient ingredient, NonNullList<ItemStack> results, float chance, float experience, int time, Advancement.Builder advancement, ResourceLocation advancementId) {
            super(CraftingBookCategory.MISC);
            this.id = id;
            this.group = group;
            this.ingredient = ingredient;
            this.results = results;
            this.chance = chance;
            this.experience = experience;
            this.time = time;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.add("ingredient", this.ingredient.m_43942_());
            JsonArray resultsArray = new JsonArray();
            for (ItemStack result : this.results) {
                resultsArray.add(GrindingResult.serializeItemStack(result));
            }
            json.add("results", (JsonElement)resultsArray);
            json.addProperty("secondaryChance", (Number)Float.valueOf(this.chance));
            json.addProperty("experience", (Number)Float.valueOf(this.experience));
            json.addProperty("processtime", (Number)this.time);
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ForceRecipeSerializers.GRINDING_SERIALIZER.get();
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }

        static JsonElement serializeItemStack(@NotNull ItemStack stack) {
            JsonObject json = new JsonObject();
            json.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString());
            if (stack.m_41613_() > 1) {
                json.addProperty("count", (Number)stack.m_41613_());
            }
            if (stack.m_41782_()) {
                json.addProperty("nbt", stack.m_41783_().toString());
            }
            return json;
        }
    }
}

