/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.datagen.data.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrbysco.forcecraft.blockentities.InfuserModifierType;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookTier;
import com.mrbysco.forcecraft.registry.ForceRecipeSerializers;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.CraftingRecipeBuilder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfuseRecipeBuilder
extends CraftingRecipeBuilder
implements RecipeBuilder {
    private final Ingredient center;
    private final Ingredient ingredient;
    private final UpgradeBookTier tier;
    private final int time;
    private InfuserModifierType resultModifier = InfuserModifierType.ITEM;
    private ItemStack output = ItemStack.f_41583_;

    public InfuseRecipeBuilder(Ingredient center, Ingredient ingredient, UpgradeBookTier tier, int time) {
        this.ingredient = ingredient;
        this.center = center;
        this.tier = tier;
        this.time = time;
    }

    public static InfuseRecipeBuilder infuse(Ingredient ingredient, Ingredient center, UpgradeBookTier tier, int time) {
        return new InfuseRecipeBuilder(center, ingredient, tier, time);
    }

    public InfuseRecipeBuilder modifierType(InfuserModifierType type) {
        this.resultModifier = type;
        return this;
    }

    public InfuseRecipeBuilder output(ItemLike outputItem) {
        this.output = new ItemStack((ItemLike)outputItem.m_5456_());
        this.resultModifier = InfuserModifierType.ITEM;
        return this;
    }

    public InfuseRecipeBuilder output(ItemLike outputItem, int count) {
        this.output = new ItemStack(outputItem, count);
        this.resultModifier = InfuserModifierType.ITEM;
        return this;
    }

    public InfuseRecipeBuilder output(ItemStack outputStack) {
        this.output = outputStack;
        this.resultModifier = InfuserModifierType.ITEM;
        return this;
    }

    public RecipeBuilder m_126132_(String id, CriterionTriggerInstance triggerInstance) {
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String pGroupName) {
        return this;
    }

    public Item m_142372_() {
        return this.output.m_41720_();
    }

    public void m_126140_(Consumer<FinishedRecipe> recipeConsumer, ResourceLocation id) {
        recipeConsumer.accept((FinishedRecipe)new Result(id, this.center, this.ingredient, this.tier, this.time, this.resultModifier, this.output));
    }

    public static class Result
    extends CraftingRecipeBuilder.CraftingResult {
        private final ResourceLocation id;
        private final Ingredient center;
        private final Ingredient ingredient;
        private final UpgradeBookTier tier;
        private final int time;
        private final InfuserModifierType resultModifier;
        private final ItemStack output;

        public Result(ResourceLocation id, Ingredient center, Ingredient ingredient, UpgradeBookTier tier, int time, InfuserModifierType resultModifier, ItemStack output) {
            super(CraftingBookCategory.MISC);
            this.id = id;
            this.center = center;
            this.ingredient = ingredient;
            this.tier = tier;
            this.time = time;
            this.resultModifier = resultModifier;
            this.output = output;
        }

        public void m_7917_(JsonObject json) {
            json.add("center", this.center.m_43942_());
            json.add("ingredient", this.ingredient.m_43942_());
            json.addProperty("result", "forcecraft:" + this.resultModifier.name().toLowerCase());
            if (this.resultModifier == InfuserModifierType.ITEM) {
                json.add("output", Result.serializeItemStack(this.output));
            }
            json.addProperty("tier", (Number)this.tier.ordinal());
            json.addProperty("time", (Number)this.time);
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ForceRecipeSerializers.INFUSER_SERIALIZER.get();
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }

        static JsonElement serializeItemStack(@NotNull ItemStack stack) {
            JsonObject json = new JsonObject();
            json.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString());
            if (stack.m_41613_() > 1) {
                json.addProperty("count", (Number)stack.m_41613_());
            }
            if (stack.m_41782_()) {
                json.addProperty("nbt", stack.m_41783_().toString());
            }
            return json;
        }
    }
}

