/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.datagen.data;

import com.mrbysco.forcecraft.datagen.data.SpoilsBagLootTableProvider;
import com.mrbysco.forcecraft.registry.ForceEntities;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.registry.ForceTables;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SlimePredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.RegistryObject;

public class ForceLootProvider
extends LootTableProvider {
    public ForceLootProvider(PackOutput packOutput) {
        super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(ForceBlockLoot::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(ForceEntityLoot::new, LootContextParamSets.f_81415_), new LootTableProvider.SubProviderEntry(SpoilsBagLootTableProvider::new, LootContextParamSets.f_81416_)));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, @Nonnull ValidationContext validationContext) {
        List<ResourceLocation> ignored = List.of(ForceTables.TIER_1, ForceTables.TIER_2, ForceTables.TIER_3);
        map.forEach((name, table) -> {
            if (!ignored.contains(name)) {
                table.m_79136_(validationContext);
            }
        });
    }

    private static class ForceEntityLoot
    extends EntityLootSubProvider {
        protected ForceEntityLoot() {
            super(FeatureFlags.f_244280_.m_247355_());
        }

        public void m_246942_() {
            this.m_245309_((EntityType)ForceEntities.COLD_CHICKEN.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42581_).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)f_244460_))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            this.m_245309_((EntityType)ForceEntities.COLD_COW.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42579_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)f_244460_))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            this.m_245309_((EntityType)ForceEntities.COLD_PIG.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42485_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)f_244460_))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            this.m_245309_((EntityType)ForceEntities.ANGRY_ENDERMAN.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42584_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            this.m_245309_((EntityType)ForceEntities.ENDER_TOT.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42584_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().name("spoils").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ForceRegistry.SPOILS_BAG.get())))));
            this.m_245309_((EntityType)ForceEntities.CREEPER_TOT.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ForceRegistry.PILE_OF_GUNPOWDER.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().name("head").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42682_))).m_79161_(LootPool.m_79043_().name("spoils").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.025f, (float)0.01f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ForceRegistry.SPOILS_BAG.get())))));
            this.m_245309_((EntityType)ForceEntities.BLUE_CHU_CHU.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)ForceRegistry.BLUE_CHU_JELLY.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79080_(this.m_245873_().m_81807_())).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)ForceRegistry.BLUE_CHU_JELLY.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79080_(this.m_245873_())).m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_218800_((EntitySubPredicate)SlimePredicate.m_223426_((MinMaxBounds.Ints)MinMaxBounds.Ints.m_55371_((int)1)))))));
            this.m_245309_((EntityType)ForceEntities.GOLD_CHU_CHU.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)ForceRegistry.GOLD_CHU_JELLY.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79080_(this.m_245873_().m_81807_())).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)ForceRegistry.GOLD_CHU_JELLY.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79080_(this.m_245873_())).m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_218800_((EntitySubPredicate)SlimePredicate.m_223426_((MinMaxBounds.Ints)MinMaxBounds.Ints.m_55371_((int)1)))))));
            this.m_245309_((EntityType)ForceEntities.GREEN_CHU_CHU.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)ForceRegistry.GREEN_CHU_JELLY.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79080_(this.m_245873_().m_81807_())).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)ForceRegistry.GREEN_CHU_JELLY.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79080_(this.m_245873_())).m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_218800_((EntitySubPredicate)SlimePredicate.m_223426_((MinMaxBounds.Ints)MinMaxBounds.Ints.m_55371_((int)1)))))));
            this.m_245309_((EntityType)ForceEntities.RED_CHU_CHU.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)ForceRegistry.RED_CHU_JELLY.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79080_(this.m_245873_().m_81807_())).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)ForceRegistry.RED_CHU_JELLY.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79080_(this.m_245873_())).m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_218800_((EntitySubPredicate)SlimePredicate.m_223426_((MinMaxBounds.Ints)MinMaxBounds.Ints.m_55371_((int)1)))))));
            this.m_245309_((EntityType)ForceEntities.FAIRY.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("main")));
        }

        protected boolean m_245552_(EntityType<?> p_249029_) {
            return super.m_245552_(p_249029_);
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return ForceEntities.ENTITY_TYPES.getEntries().stream().map(RegistryObject::get);
        }
    }

    private static class ForceBlockLoot
    extends BlockLootSubProvider {
        protected ForceBlockLoot() {
            super(Set.of(), FeatureFlags.f_244280_.m_247355_());
        }

        public void m_245660_() {
            this.m_246481_((Block)ForceRegistry.POWER_ORE.get(), ore -> ForceBlockLoot.m_247502_((Block)ore, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)ForceRegistry.POWER_ORE_ITEM.get(), (FunctionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)ForceRegistry.FORCE_GEM.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_))))));
            this.m_246481_((Block)ForceRegistry.DEEPSLATE_POWER_ORE.get(), ore -> ForceBlockLoot.m_247502_((Block)ore, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)ForceRegistry.POWER_ORE_ITEM.get(), (FunctionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)ForceRegistry.FORCE_GEM.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_))))));
            this.m_245724_((Block)ForceRegistry.INFUSER.get());
            this.m_247577_((Block)ForceRegistry.FORCE_FURNACE.get(), this.m_246180_((Block)ForceRegistry.FORCE_FURNACE.get()));
            this.m_247577_((Block)ForceRegistry.BLACK_FORCE_FURNACE.get(), this.m_246180_((Block)ForceRegistry.BLACK_FORCE_FURNACE.get()));
            this.m_247577_((Block)ForceRegistry.BLUE_FORCE_FURNACE.get(), this.m_246180_((Block)ForceRegistry.BLUE_FORCE_FURNACE.get()));
            this.m_247577_((Block)ForceRegistry.BROWN_FORCE_FURNACE.get(), this.m_246180_((Block)ForceRegistry.BROWN_FORCE_FURNACE.get()));
            this.m_247577_((Block)ForceRegistry.CYAN_FORCE_FURNACE.get(), this.m_246180_((Block)ForceRegistry.CYAN_FORCE_FURNACE.get()));
            this.m_247577_((Block)ForceRegistry.GRAY_FORCE_FURNACE.get(), this.m_246180_((Block)ForceRegistry.GRAY_FORCE_FURNACE.get()));
            this.m_247577_((Block)ForceRegistry.GREEN_FORCE_FURNACE.get(), this.m_246180_((Block)ForceRegistry.GREEN_FORCE_FURNACE.get()));
            this.m_247577_((Block)ForceRegistry.LIGHT_BLUE_FORCE_FURNACE.get(), this.m_246180_((Block)ForceRegistry.LIGHT_BLUE_FORCE_FURNACE.get()));
            this.m_247577_((Block)ForceRegistry.LIGHT_GRAY_FORCE_FURNACE.get(), this.m_246180_((Block)ForceRegistry.LIGHT_GRAY_FORCE_FURNACE.get()));
            this.m_247577_((Block)ForceRegistry.LIME_FORCE_FURNACE.get(), this.m_246180_((Block)ForceRegistry.LIME_FORCE_FURNACE.get()));
            this.m_247577_((Block)ForceRegistry.MAGENTA_FORCE_FURNACE.get(), this.m_246180_((Block)ForceRegistry.MAGENTA_FORCE_FURNACE.get()));
            this.m_247577_((Block)ForceRegistry.ORANGE_FORCE_FURNACE.get(), this.m_246180_((Block)ForceRegistry.ORANGE_FORCE_FURNACE.get()));
            this.m_247577_((Block)ForceRegistry.PINK_FORCE_FURNACE.get(), this.m_246180_((Block)ForceRegistry.PINK_FORCE_FURNACE.get()));
            this.m_247577_((Block)ForceRegistry.PURPLE_FORCE_FURNACE.get(), this.m_246180_((Block)ForceRegistry.PURPLE_FORCE_FURNACE.get()));
            this.m_247577_((Block)ForceRegistry.RED_FORCE_FURNACE.get(), this.m_246180_((Block)ForceRegistry.RED_FORCE_FURNACE.get()));
            this.m_247577_((Block)ForceRegistry.WHITE_FORCE_FURNACE.get(), this.m_246180_((Block)ForceRegistry.WHITE_FORCE_FURNACE.get()));
            this.m_247577_((Block)ForceRegistry.FORCE_ENGINE.get(), this.m_246180_((Block)ForceRegistry.FORCE_ENGINE.get()));
            this.m_245724_((Block)ForceRegistry.FORCE_SAPLING.get());
            this.m_245724_((Block)ForceRegistry.FORCE_LOG.get());
            this.m_245724_((Block)ForceRegistry.FORCE_WOOD.get());
            this.m_245724_((Block)ForceRegistry.FORCE_PLANKS.get());
            this.m_246481_((Block)ForceRegistry.FORCE_LEAVES.get(), leaves -> {
                LootTable.Builder pool = this.m_246142_((Block)leaves, (Block)ForceRegistry.FORCE_SAPLING.get(), f_244509_);
                pool.m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(f_243905_.m_285888_(f_243678_).m_81807_()).m_79076_(((LootPoolSingletonContainer.Builder)this.m_247733_((ItemLike)leaves, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)ForceRegistry.FORCE_NUGGET.get())))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.025f, 0.03f, 0.035f, 0.04f, 0.045f}))));
                return pool;
            });
            this.m_245724_((Block)ForceRegistry.FORCE_TORCH.get());
            this.m_245724_((Block)ForceRegistry.FORCE_RED_TORCH.get());
            this.m_245724_((Block)ForceRegistry.FORCE_ORANGE_TORCH.get());
            this.m_245724_((Block)ForceRegistry.FORCE_GREEN_TORCH.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BLUE_TORCH.get());
            this.m_245724_((Block)ForceRegistry.FORCE_WHITE_TORCH.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BLACK_TORCH.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BROWN_TORCH.get());
            this.m_245724_((Block)ForceRegistry.FORCE_LIGHT_BLUE_TORCH.get());
            this.m_245724_((Block)ForceRegistry.FORCE_MAGENTA_TORCH.get());
            this.m_245724_((Block)ForceRegistry.FORCE_PINK_TORCH.get());
            this.m_245724_((Block)ForceRegistry.FORCE_LIGHT_GRAY_TORCH.get());
            this.m_245724_((Block)ForceRegistry.FORCE_LIME_TORCH.get());
            this.m_245724_((Block)ForceRegistry.FORCE_CYAN_TORCH.get());
            this.m_245724_((Block)ForceRegistry.FORCE_PURPLE_TORCH.get());
            this.m_245724_((Block)ForceRegistry.FORCE_GRAY_TORCH.get());
            this.m_245724_((Block)ForceRegistry.TIME_TORCH.get());
            this.m_246125_((Block)ForceRegistry.WALL_FORCE_TORCH.get(), (ItemLike)ForceRegistry.FORCE_TORCH.get());
            this.m_246125_((Block)ForceRegistry.WALL_FORCE_RED_TORCH.get(), (ItemLike)ForceRegistry.FORCE_RED_TORCH.get());
            this.m_246125_((Block)ForceRegistry.WALL_FORCE_ORANGE_TORCH.get(), (ItemLike)ForceRegistry.FORCE_ORANGE_TORCH.get());
            this.m_246125_((Block)ForceRegistry.WALL_FORCE_GREEN_TORCH.get(), (ItemLike)ForceRegistry.FORCE_GREEN_TORCH.get());
            this.m_246125_((Block)ForceRegistry.WALL_FORCE_BLUE_TORCH.get(), (ItemLike)ForceRegistry.FORCE_BLUE_TORCH.get());
            this.m_246125_((Block)ForceRegistry.WALL_FORCE_WHITE_TORCH.get(), (ItemLike)ForceRegistry.FORCE_WHITE_TORCH.get());
            this.m_246125_((Block)ForceRegistry.WALL_FORCE_BLACK_TORCH.get(), (ItemLike)ForceRegistry.FORCE_BLACK_TORCH.get());
            this.m_246125_((Block)ForceRegistry.WALL_FORCE_BROWN_TORCH.get(), (ItemLike)ForceRegistry.FORCE_BROWN_TORCH.get());
            this.m_246125_((Block)ForceRegistry.WALL_FORCE_LIGHT_BLUE_TORCH.get(), (ItemLike)ForceRegistry.FORCE_LIGHT_BLUE_TORCH.get());
            this.m_246125_((Block)ForceRegistry.WALL_FORCE_MAGENTA_TORCH.get(), (ItemLike)ForceRegistry.FORCE_MAGENTA_TORCH.get());
            this.m_246125_((Block)ForceRegistry.WALL_FORCE_PINK_TORCH.get(), (ItemLike)ForceRegistry.FORCE_PINK_TORCH.get());
            this.m_246125_((Block)ForceRegistry.WALL_FORCE_LIGHT_GRAY_TORCH.get(), (ItemLike)ForceRegistry.FORCE_LIGHT_GRAY_TORCH.get());
            this.m_246125_((Block)ForceRegistry.WALL_FORCE_LIME_TORCH.get(), (ItemLike)ForceRegistry.FORCE_LIME_TORCH.get());
            this.m_246125_((Block)ForceRegistry.WALL_FORCE_CYAN_TORCH.get(), (ItemLike)ForceRegistry.FORCE_CYAN_TORCH.get());
            this.m_246125_((Block)ForceRegistry.WALL_FORCE_PURPLE_TORCH.get(), (ItemLike)ForceRegistry.FORCE_PURPLE_TORCH.get());
            this.m_246125_((Block)ForceRegistry.WALL_FORCE_GRAY_TORCH.get(), (ItemLike)ForceRegistry.FORCE_GRAY_TORCH.get());
            this.m_245724_((Block)ForceRegistry.WALL_TIME_TORCH.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_RED.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_YELLOW.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_GREEN.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_BLUE.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_WHITE.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_BLACK.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_BROWN.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_ORANGE.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_LIGHT_BLUE.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_MAGENTA.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_PINK.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_LIGHT_GRAY.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_LIME.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_CYAN.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_PURPLE.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_GRAY.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK.get());
            this.m_245724_((Block)ForceRegistry.FORCE_PLANK_STAIRS.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_RED_STAIRS.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_YELLOW_STAIRS.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_GREEN_STAIRS.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_BLUE_STAIRS.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_WHITE_STAIRS.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_BLACK_STAIRS.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_BROWN_STAIRS.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_ORANGE_STAIRS.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_LIGHT_BLUE_STAIRS.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_MAGENTA_STAIRS.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_PINK_STAIRS.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_LIGHT_GRAY_STAIRS.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_LIME_STAIRS.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_CYAN_STAIRS.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_PURPLE_STAIRS.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_GRAY_STAIRS.get());
            this.m_245724_((Block)ForceRegistry.FORCE_BRICK_STAIRS.get());
            this.m_247577_((Block)ForceRegistry.FORCE_PLANK_SLAB.get(), this.m_247233_((Block)ForceRegistry.FORCE_PLANK_SLAB.get()));
            this.m_247577_((Block)ForceRegistry.FORCE_BRICK_RED_SLAB.get(), this.m_247233_((Block)ForceRegistry.FORCE_BRICK_RED_SLAB.get()));
            this.m_247577_((Block)ForceRegistry.FORCE_BRICK_YELLOW_SLAB.get(), this.m_247233_((Block)ForceRegistry.FORCE_BRICK_YELLOW_SLAB.get()));
            this.m_247577_((Block)ForceRegistry.FORCE_BRICK_GREEN_SLAB.get(), this.m_247233_((Block)ForceRegistry.FORCE_BRICK_GREEN_SLAB.get()));
            this.m_247577_((Block)ForceRegistry.FORCE_BRICK_BLUE_SLAB.get(), this.m_247233_((Block)ForceRegistry.FORCE_BRICK_BLUE_SLAB.get()));
            this.m_247577_((Block)ForceRegistry.FORCE_BRICK_WHITE_SLAB.get(), this.m_247233_((Block)ForceRegistry.FORCE_BRICK_WHITE_SLAB.get()));
            this.m_247577_((Block)ForceRegistry.FORCE_BRICK_BLACK_SLAB.get(), this.m_247233_((Block)ForceRegistry.FORCE_BRICK_BLACK_SLAB.get()));
            this.m_247577_((Block)ForceRegistry.FORCE_BRICK_BROWN_SLAB.get(), this.m_247233_((Block)ForceRegistry.FORCE_BRICK_BROWN_SLAB.get()));
            this.m_247577_((Block)ForceRegistry.FORCE_BRICK_ORANGE_SLAB.get(), this.m_247233_((Block)ForceRegistry.FORCE_BRICK_ORANGE_SLAB.get()));
            this.m_247577_((Block)ForceRegistry.FORCE_BRICK_LIGHT_BLUE_SLAB.get(), this.m_247233_((Block)ForceRegistry.FORCE_BRICK_LIGHT_BLUE_SLAB.get()));
            this.m_247577_((Block)ForceRegistry.FORCE_BRICK_MAGENTA_SLAB.get(), this.m_247233_((Block)ForceRegistry.FORCE_BRICK_MAGENTA_SLAB.get()));
            this.m_247577_((Block)ForceRegistry.FORCE_BRICK_PINK_SLAB.get(), this.m_247233_((Block)ForceRegistry.FORCE_BRICK_PINK_SLAB.get()));
            this.m_247577_((Block)ForceRegistry.FORCE_BRICK_LIGHT_GRAY_SLAB.get(), this.m_247233_((Block)ForceRegistry.FORCE_BRICK_LIGHT_GRAY_SLAB.get()));
            this.m_247577_((Block)ForceRegistry.FORCE_BRICK_LIME_SLAB.get(), this.m_247233_((Block)ForceRegistry.FORCE_BRICK_LIME_SLAB.get()));
            this.m_247577_((Block)ForceRegistry.FORCE_BRICK_CYAN_SLAB.get(), this.m_247233_((Block)ForceRegistry.FORCE_BRICK_CYAN_SLAB.get()));
            this.m_247577_((Block)ForceRegistry.FORCE_BRICK_PURPLE_SLAB.get(), this.m_247233_((Block)ForceRegistry.FORCE_BRICK_PURPLE_SLAB.get()));
            this.m_247577_((Block)ForceRegistry.FORCE_BRICK_GRAY_SLAB.get(), this.m_247233_((Block)ForceRegistry.FORCE_BRICK_GRAY_SLAB.get()));
            this.m_247577_((Block)ForceRegistry.FORCE_BRICK_SLAB.get(), this.m_247233_((Block)ForceRegistry.FORCE_BRICK_SLAB.get()));
        }

        protected Iterable<Block> getKnownBlocks() {
            return ForceRegistry.BLOCKS.getEntries().stream().map(holder -> (Block)holder.get())::iterator;
        }
    }
}

