/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class RenderHelper {
    public static void drawFluidTankInGUI(FluidStack fluid, double x, double y, double percent, int height) {
        TextureAtlasSprite sprite;
        if (fluid == null || fluid.isEmpty()) {
            return;
        }
        ResourceLocation flowing = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getStillTexture(fluid);
        AbstractTexture texture = Minecraft.m_91087_().m_91097_().m_118506_(InventoryMenu.f_39692_);
        if (texture instanceof TextureAtlas && (sprite = ((TextureAtlas)texture).m_118316_(flowing)) != null) {
            float minU = sprite.m_118409_();
            float maxU = sprite.m_118410_();
            float minV = sprite.m_118411_();
            float maxV = sprite.m_118412_();
            float deltaV = maxV - minV;
            double tankLevel = percent * (double)height;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            Color color = new Color(IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getTintColor(fluid));
            RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
            RenderSystem.enableBlend();
            int count = 1 + (int)Math.ceil(tankLevel) / 16;
            for (int i = 0; i < count; ++i) {
                double subHeight = Math.min(16.0, tankLevel - 16.0 * (double)i);
                double offsetY = (double)height - 16.0 * (double)i - subHeight;
                RenderHelper.drawQuad(x, y + offsetY, 16.0, subHeight, minU, (float)((double)maxV - (double)deltaV * (subHeight / 16.0)), maxU, maxV);
            }
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private static void drawQuad(double x, double y, double width, double height, float minU, float minV, float maxU, float maxV) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_(x, y + height, 0.0).m_7421_(minU, maxV).m_5752_();
        buffer.m_5483_(x + width, y + height, 0.0).m_7421_(maxU, maxV).m_5752_();
        buffer.m_5483_(x + width, y, 0.0).m_7421_(maxU, minV).m_5752_();
        buffer.m_5483_(x, y, 0.0).m_7421_(minU, minV).m_5752_();
        tesselator.m_85914_();
    }

    public static float getTankPercentage(int fluidAmount, int fluidMax) {
        return (float)fluidAmount / (float)fluidMax;
    }

    public static int getFluidGuiPercentage(int percentage, int maxHeight) {
        return (int)Math.ceil((float)percentage * (float)maxHeight);
    }
}

