/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.client.gui.infuser;

import com.mrbysco.forcecraft.blockentities.InfuserBlockEntity;
import com.mrbysco.forcecraft.client.gui.widgets.ProgressBar;
import com.mrbysco.forcecraft.client.util.RenderHelper;
import com.mrbysco.forcecraft.compat.patchouli.PatchouliCompat;
import com.mrbysco.forcecraft.menu.infuser.InfuserMenu;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;

public class InfuserScreen
extends AbstractContainerScreen<InfuserMenu> {
    private Inventory inventory;
    private ProgressBar infuserProgress;
    private final ResourceLocation INFO = new ResourceLocation("forcecraft", "textures/gui/container/info.png");
    private final ResourceLocation ENERGY = new ResourceLocation("forcecraft", "textures/gui/container/energy.png");
    private final ResourceLocation TEXTURE = new ResourceLocation("forcecraft", "textures/gui/container/forceinfuser.png");
    private Button buttonInfuse;
    private Button buttonGuide;

    public InfuserScreen(InfuserMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.inventory = inv;
        this.f_97727_ = 208;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.infuserProgress = new ProgressBar(this.TEXTURE, ProgressBar.ProgressBarDirection.DOWN_TO_UP, 2, 20, this.f_97735_ + 134, this.f_97736_ + 93, 176, 0);
        int btnSize = 13;
        int x = 123;
        int y = 16;
        this.buttonGuide = (Button)this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + x, this.f_97736_ + y, btnSize, btnSize, 201, 0, 0, this.TEXTURE, 256, 256, button -> {
            if (ModList.get().isLoaded("patchouli")) {
                PatchouliCompat.openBook();
            } else {
                this.inventory.f_35978_.m_5661_((Component)Component.m_237115_((String)"gui.forcecraft.infuser.patchouli"), false);
            }
        }, (Component)Component.m_237115_((String)"gui.forcecraft.infuser.button.guide")));
        x = 39;
        y = 101;
        this.buttonInfuse = (Button)this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + x, this.f_97736_ + y, btnSize, btnSize, 188, 0, 0, this.TEXTURE, 256, 256, button -> {
            ItemStack bookStack = ((InfuserMenu)this.f_97732_).getTile().getBookInSlot();
            if (bookStack.m_41619_()) {
                this.inventory.f_35978_.m_5661_((Component)Component.m_237115_((String)"gui.forcecraft.infuser.nobook"), false);
            } else {
                this.f_96541_.f_91072_.m_105208_(((InfuserMenu)this.f_97732_).f_38840_, 0);
            }
        }, (Component)Component.m_237119_()));
    }

    protected void m_181908_() {
        boolean flag2;
        boolean flag;
        super.m_181908_();
        boolean bl = flag = ((InfuserMenu)this.m_6262_()).validRecipe[0] == 1;
        if (this.buttonInfuse.f_93624_ != flag) {
            this.buttonInfuse.f_93624_ = flag;
        }
        boolean bl2 = flag2 = !((InfuserMenu)this.f_97732_).getTile().getBookInSlot().m_41619_();
        if (this.buttonGuide.f_93624_ != flag2) {
            this.buttonGuide.f_93624_ = flag2;
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        guiGraphics.m_280218_(this.TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        this.drawFluidBar(guiGraphics);
        this.drawEnergyBar(guiGraphics);
        this.drawProgressBar(guiGraphics);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<MutableComponent> text;
        int actualMouseX = mouseX - (this.f_96543_ - this.f_97726_) / 2;
        int actualMouseY = mouseY - (this.f_96544_ - this.f_97727_) / 2;
        InfuserBlockEntity tile = ((InfuserMenu)this.f_97732_).getTile();
        if (this.m_6774_(123, 16, 12, 12, mouseX, mouseY) && tile.handler.getStackInSlot(9).m_41619_()) {
            text = new ArrayList<MutableComponent>();
            text.add(Component.m_237115_((String)"gui.forcecraft.infuser.help.tooltip").m_130940_(ChatFormatting.GRAY));
            guiGraphics.m_280666_(this.f_96547_, text, actualMouseX, actualMouseY);
        }
        if (this.m_6774_(39, 101, 12, 12, mouseX, mouseY)) {
            text = new ArrayList();
            if (((InfuserMenu)this.m_6262_()).isWorkAllowed()) {
                if (((InfuserMenu)this.m_6262_()).validRecipe[0] == 0) {
                    text.add(Component.m_237115_((String)"gui.forcecraft.infuser.missing.recipe").m_130940_(ChatFormatting.RED));
                } else {
                    text.add(Component.m_237115_((String)"gui.forcecraft.infuser.start.tooltip").m_130940_(ChatFormatting.GRAY));
                }
            } else {
                boolean modifiersEmpty = tile.areAllModifiersEmpty();
                if (!modifiersEmpty && tile.getEnergyStored() < tile.getEnergyCostPer()) {
                    text.add(Component.m_237115_((String)"gui.forcecraft.infuser.missing.rf.tooltip").m_130940_(ChatFormatting.RED));
                } else {
                    text.add(Component.m_237115_((String)"gui.forcecraft.infuser.missing.tooltip").m_130940_(ChatFormatting.RED));
                }
            }
            guiGraphics.m_280666_(this.f_96547_, text, actualMouseX, actualMouseY);
        }
        if (this.m_6774_(156, 8, 12, 112, mouseX, mouseY)) {
            text = new ArrayList();
            MutableComponent tt = Component.m_237113_((String)(tile.getEnergyStored() + " RF")).m_130940_(ChatFormatting.GOLD);
            text.add(tt);
            guiGraphics.m_280666_(this.f_96547_, text, actualMouseX, actualMouseY);
        }
        if (this.m_6774_(10, 41, 15, 82, mouseX, mouseY)) {
            text = new ArrayList();
            if (tile.getFluid() == null) {
                text.add(Component.m_237115_((String)"gui.forcecraft.infuser.empty.tooltip"));
            } else {
                text.add(Component.m_237115_((String)"fluid.forcecraft.fluid_force_source"));
                text.add(Component.m_237113_((String)(tile.getFluidAmount() + " mb")).m_130940_(ChatFormatting.YELLOW));
            }
            guiGraphics.m_280666_(this.f_96547_, text, actualMouseX, actualMouseY);
        }
    }

    private void drawFluidBar(GuiGraphics guiGraphics) {
        if (((InfuserMenu)this.f_97732_).getTile() == null || ((InfuserMenu)this.f_97732_).getTile().getFluid() == null) {
            return;
        }
        FluidStack fluidStack = ((InfuserMenu)this.f_97732_).getTile().getFluidStack();
        float tankPercentage = RenderHelper.getTankPercentage(((InfuserMenu)this.m_6262_()).getTile().getFluidAmount(), 50000);
        RenderHelper.drawFluidTankInGUI(fluidStack, this.f_97735_ + 8, this.f_97736_ + 41, tankPercentage, 82);
        guiGraphics.m_280218_(this.TEXTURE, this.f_97735_ + 8, this.f_97736_ + 41, 188, 26, 16, 82);
    }

    private void drawEnergyBar(GuiGraphics guiGraphics) {
        if (((InfuserMenu)this.f_97732_).getTile() == null || ((InfuserMenu)this.f_97732_).getTile().energyStorage.getMaxEnergyStored() <= 0) {
            return;
        }
        float energy = ((InfuserMenu)this.m_6262_()).getTile().getEnergyStored();
        float capacity = ((InfuserMenu)this.f_97732_).getTile().energyStorage.getMaxEnergyStored();
        float pct = Math.min(energy / capacity, 1.0f);
        float height = 107.0f;
        int width = 12;
        guiGraphics.m_280163_(this.ENERGY, this.f_97735_ + 156, this.f_97736_ + 13, 0.0f, 0.0f, width, (int)(107.0f * pct), width, 107);
    }

    private void drawProgressBar(GuiGraphics guiGraphics) {
        InfuserBlockEntity tile = ((InfuserMenu)this.f_97732_).getTile();
        if (tile.canWork) {
            this.infuserProgress.setMin(tile.processTime).setMax(tile.maxProcessTime);
            this.infuserProgress.draw(guiGraphics);
        }
    }
}

