/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.capabilities.toolmodifier;

import com.mrbysco.forcecraft.capabilities.CapabilityHandler;
import com.mrbysco.forcecraft.capabilities.toolmodifier.IToolModifier;
import com.mrbysco.forcecraft.items.ForceArmorItem;
import com.mrbysco.forcecraft.items.tools.ForceBowItem;
import com.mrbysco.forcecraft.items.tools.ForcePickaxeItem;
import com.mrbysco.forcecraft.items.tools.ForceRodItem;
import com.mrbysco.forcecraft.items.tools.ForceShearsItem;
import com.mrbysco.forcecraft.items.tools.ForceShovelItem;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class ToolModCapability
implements IToolModifier,
ICapabilitySerializable<CompoundTag>,
ICapabilityProvider {
    private int speed;
    private boolean heat;
    private int force;
    private boolean silk;
    private int sharpness;
    private int luck;
    private int sturdy;
    boolean rainbow;
    boolean lumberJack;
    int bleed;
    int bane;
    boolean wing;
    boolean camo;
    boolean sight;
    boolean light;
    boolean ender;
    boolean freezing;
    boolean treasure;

    @Override
    public int getSpeedLevel() {
        return this.speed;
    }

    @Override
    public void incrementSpeed() {
        ++this.speed;
    }

    @Override
    public void setSpeed(int newSpeed) {
        this.speed = newSpeed;
    }

    @Override
    public boolean hasHeat() {
        return this.heat;
    }

    @Override
    public void setHeat(boolean val) {
        this.heat = val;
    }

    @Override
    public int getForceLevel() {
        return this.force;
    }

    @Override
    public boolean hasForce() {
        return this.force != 0;
    }

    @Override
    public void incrementForce() {
        ++this.force;
    }

    @Override
    public void setForce(int newForce) {
        this.force = newForce;
    }

    @Override
    public boolean hasSilk() {
        return this.silk;
    }

    @Override
    public void setSilk(boolean val) {
        this.silk = val;
    }

    @Override
    public int getSharpLevel() {
        return this.sharpness;
    }

    @Override
    public boolean hasSharp() {
        return this.sharpness > 0;
    }

    @Override
    public void incrementSharp() {
        ++this.sharpness;
    }

    @Override
    public void setSharp(int newSharp) {
        this.sharpness = newSharp;
    }

    @Override
    public int getLuckLevel() {
        return this.luck;
    }

    @Override
    public boolean hasLuck() {
        return this.luck > 0;
    }

    @Override
    public void incrementLuck() {
        ++this.luck;
    }

    @Override
    public void setLuck(int newLuck) {
        this.luck = newLuck;
    }

    @Override
    public int getSturdyLevel() {
        return this.sturdy;
    }

    @Override
    public boolean hasSturdy() {
        return this.sturdy > 0;
    }

    @Override
    public void incrementSturdy() {
        ++this.sturdy;
    }

    @Override
    public void setSturdy(int newSturdy) {
        this.sturdy = newSturdy;
    }

    @Override
    public boolean hasRainbow() {
        return this.rainbow;
    }

    @Override
    public void setRainbow(boolean val) {
        this.rainbow = val;
    }

    @Override
    public boolean hasLumberjack() {
        return this.lumberJack;
    }

    @Override
    public void setLumberjack(boolean val) {
        this.lumberJack = val;
    }

    @Override
    public int getBleedLevel() {
        return this.bleed;
    }

    @Override
    public boolean hasBleed() {
        return this.bleed > 0;
    }

    @Override
    public void incrementBleed() {
        ++this.bleed;
    }

    @Override
    public void setBleed(int newBleed) {
        this.bleed = newBleed;
    }

    @Override
    public int getBaneLevel() {
        return this.bane;
    }

    @Override
    public boolean hasBane() {
        return this.bane > 0;
    }

    @Override
    public void incrementBane() {
        ++this.bane;
    }

    @Override
    public void setBane(int newBane) {
        this.bane = newBane;
    }

    @Override
    public boolean hasWing() {
        return this.wing;
    }

    @Override
    public void setWing(boolean val) {
        this.wing = val;
    }

    @Override
    public boolean hasCamo() {
        return this.camo;
    }

    @Override
    public void setCamo(boolean val) {
        this.camo = val;
    }

    @Override
    public boolean hasSight() {
        return this.sight;
    }

    @Override
    public void setSight(boolean val) {
        this.sight = val;
    }

    @Override
    public boolean hasLight() {
        return this.light;
    }

    @Override
    public void setLight(boolean val) {
        this.light = val;
    }

    @Override
    public boolean hasEnder() {
        return this.ender;
    }

    @Override
    public void setEnder(boolean val) {
        this.ender = val;
    }

    @Override
    public boolean hasFreezing() {
        return this.freezing;
    }

    @Override
    public void setFreezing(boolean val) {
        this.freezing = val;
    }

    @Override
    public boolean hasTreasure() {
        return this.treasure;
    }

    @Override
    public void setTreasure(boolean val) {
        this.treasure = val;
    }

    public static void attachInformation(ItemStack stack, List<Component> tooltip) {
        stack.getCapability(CapabilityHandler.CAPABILITY_TOOLMOD).ifPresent(cap -> {
            Item item = stack.m_41720_();
            if (cap.getSpeedLevel() > 0 && (item instanceof ForceBowItem || item instanceof ForceArmorItem || item instanceof ForceRodItem)) {
                tooltip.add((Component)Component.m_237115_((String)("item.infuser.tooltip.speed" + cap.getSpeedLevel())).m_130940_(ChatFormatting.YELLOW));
            }
            if (cap.hasLumberjack()) {
                tooltip.add((Component)Component.m_237115_((String)"item.infuser.tooltip.lumberjack").m_130940_(ChatFormatting.YELLOW));
            }
            if (cap.getLuckLevel() > 0 && (item instanceof ForceBowItem || item instanceof ForceArmorItem)) {
                tooltip.add((Component)Component.m_237115_((String)("item.infuser.tooltip.luck" + cap.getLuckLevel())).m_130940_(ChatFormatting.GREEN));
            }
            if (cap.getBaneLevel() > 0) {
                tooltip.add((Component)Component.m_237115_((String)"item.infuser.tooltip.bane").m_130940_(ChatFormatting.LIGHT_PURPLE));
            }
            if (cap.getSturdyLevel() > 0 && stack.m_41720_() instanceof ForceArmorItem) {
                tooltip.add((Component)Component.m_237115_((String)("item.infuser.tooltip.sturdy" + cap.getSturdyLevel())).m_130940_(ChatFormatting.DARK_PURPLE));
            }
            if (cap.hasWing()) {
                tooltip.add((Component)Component.m_237115_((String)"item.infuser.tooltip.wing"));
            }
            if (cap.hasBleed()) {
                tooltip.add((Component)Component.m_237115_((String)("item.infuser.tooltip.bleed" + cap.getBleedLevel())).m_130940_(ChatFormatting.RED));
            }
            if (cap.hasRainbow()) {
                tooltip.add((Component)Component.m_237115_((String)"item.infuser.tooltip.rainbow").m_130940_(ChatFormatting.GOLD));
            }
            if (cap.hasHeat() && (item instanceof ForceShovelItem || item instanceof ForcePickaxeItem || item instanceof ForceShearsItem || item instanceof ForceArmorItem)) {
                tooltip.add((Component)Component.m_237115_((String)"item.infuser.tooltip.heat").m_130940_(ChatFormatting.RED));
            }
            if (cap.hasCamo()) {
                tooltip.add((Component)Component.m_237115_((String)"item.infuser.tooltip.camo").m_130940_(ChatFormatting.DARK_GREEN));
            }
            if (cap.hasEnder()) {
                tooltip.add((Component)Component.m_237115_((String)"item.infuser.tooltip.ender").m_130940_(ChatFormatting.DARK_PURPLE));
            }
            if (cap.hasFreezing()) {
                tooltip.add((Component)Component.m_237115_((String)"item.infuser.tooltip.freezing").m_130940_(ChatFormatting.BLUE));
            }
            if (cap.hasTreasure()) {
                tooltip.add((Component)Component.m_237115_((String)"item.infuser.tooltip.treasure").m_130940_(ChatFormatting.GOLD));
            }
            if (cap.hasLight()) {
                tooltip.add((Component)Component.m_237115_((String)"item.infuser.tooltip.light").m_130940_(ChatFormatting.GOLD));
            }
            if (cap.hasSharp() && stack.m_41720_() instanceof ForceArmorItem) {
                tooltip.add((Component)Component.m_237115_((String)"item.infuser.tooltip.sharp").m_130940_(ChatFormatting.GOLD));
            }
        });
    }

    public CompoundTag serializeNBT() {
        return ToolModCapability.writeNBT(this);
    }

    public void deserializeNBT(CompoundTag nbt) {
        ToolModCapability.readNBT(this, nbt);
    }

    public static CompoundTag writeNBT(IToolModifier instance) {
        if (instance == null) {
            return null;
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("speed", instance.getSpeedLevel());
        tag.m_128379_("heat", instance.hasHeat());
        tag.m_128405_("force", instance.getForceLevel());
        tag.m_128379_("silk", instance.hasSilk());
        tag.m_128405_("sharp", instance.getSharpLevel());
        tag.m_128405_("luck", instance.getLuckLevel());
        tag.m_128405_("sturdy", instance.getSturdyLevel());
        tag.m_128379_("rainbow", instance.hasRainbow());
        tag.m_128379_("lumber", instance.hasLumberjack());
        tag.m_128405_("bleed", instance.getBleedLevel());
        tag.m_128405_("bane", instance.getBaneLevel());
        tag.m_128379_("wing", instance.hasWing());
        tag.m_128379_("camo", instance.hasCamo());
        tag.m_128379_("sight", instance.hasSight());
        tag.m_128379_("light", instance.hasLight());
        tag.m_128379_("ender", instance.hasEnder());
        tag.m_128379_("freezing", instance.hasFreezing());
        tag.m_128379_("treasure", instance.hasTreasure());
        return tag;
    }

    public static void readNBT(IToolModifier instance, CompoundTag tag) {
        instance.setSpeed(tag.m_128451_("speed"));
        instance.setHeat(tag.m_128471_("heat"));
        instance.setForce(tag.m_128451_("force"));
        instance.setSilk(tag.m_128471_("silk"));
        instance.setSharp(tag.m_128451_("sharp"));
        instance.setLuck(tag.m_128451_("luck"));
        instance.setSturdy(tag.m_128451_("sturdy"));
        instance.setRainbow(tag.m_128471_("rainbow"));
        instance.setLumberjack(tag.m_128471_("lumber"));
        instance.setBleed(tag.m_128451_("bleed"));
        instance.setBane(tag.m_128451_("bane"));
        instance.setWing(tag.m_128471_("wing"));
        instance.setCamo(tag.m_128471_("camo"));
        instance.setSight(tag.m_128471_("sight"));
        instance.setLight(tag.m_128471_("light"));
        instance.setEnder(tag.m_128471_("ender"));
        instance.setFreezing(tag.m_128471_("freezing"));
        instance.setTreasure(tag.m_128471_("treasure"));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CapabilityHandler.CAPABILITY_TOOLMOD.orEmpty(cap, LazyOptional.of(() -> this));
    }

    public final Capability<IToolModifier> getCapability() {
        return CapabilityHandler.CAPABILITY_TOOLMOD;
    }
}

