/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.capabilities.banemodifier;

import com.mrbysco.forcecraft.capabilities.CapabilityHandler;
import com.mrbysco.forcecraft.capabilities.banemodifier.IBaneModifier;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class BaneModifierCapability
implements IBaneModifier,
ICapabilitySerializable<CompoundTag>,
ICapabilityProvider {
    boolean canTeleport = true;
    boolean canExplode = true;

    @Override
    public boolean canTeleport() {
        return this.canTeleport;
    }

    @Override
    public void setTeleportAbility(boolean canTeleport) {
        this.canTeleport = canTeleport;
    }

    @Override
    public boolean canExplode() {
        return this.canExplode;
    }

    @Override
    public void setExplodeAbility(boolean canExplode) {
        this.canExplode = canExplode;
    }

    public CompoundTag serializeNBT() {
        return this.writeNBT(this);
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.readNBT(this, nbt);
    }

    public CompoundTag writeNBT(IBaneModifier instance) {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("canTeleport", instance.canTeleport());
        tag.m_128379_("canExplode", instance.canExplode());
        return tag;
    }

    public void readNBT(IBaneModifier instance, CompoundTag tag) {
        instance.setTeleportAbility(tag.m_128471_("canTeleport"));
        instance.setExplodeAbility(tag.m_128471_("canExplode"));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CapabilityHandler.CAPABILITY_BANE.orEmpty(cap, LazyOptional.of(() -> this));
    }

    public Capability<IBaneModifier> getCapability() {
        return CapabilityHandler.CAPABILITY_BANE;
    }
}

