/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.capabilities;

import com.mrbysco.forcecraft.capabilities.CapabilityHandler;
import com.mrbysco.forcecraft.capabilities.banemodifier.BaneModifierCapability;
import com.mrbysco.forcecraft.capabilities.playermodifier.IPlayerModifier;
import com.mrbysco.forcecraft.capabilities.playermodifier.PlayerModifierCapability;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CapabilityAttachHandler {
    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EnderMan || event.getObject() instanceof Creeper) {
            event.addCapability(CapabilityHandler.BANE_CAP, (ICapabilityProvider)new BaneModifierCapability());
        }
        if (event.getObject() instanceof Player) {
            event.addCapability(CapabilityHandler.PLAYER_CAP, (ICapabilityProvider)new PlayerModifierCapability());
        }
    }

    @SubscribeEvent
    public void onDeath(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        Player original = event.getOriginal();
        Player clone = event.getEntity();
        Capability<IPlayerModifier> capability = CapabilityHandler.CAPABILITY_PLAYERMOD;
        original.getCapability(capability).ifPresent(dataOriginal -> clone.getCapability(capability).ifPresent(dataClone -> {
            CompoundTag tag = PlayerModifierCapability.writeNBT(dataOriginal);
            PlayerModifierCapability.readNBT(dataClone, tag);
        }));
    }
}

