/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.blocks;

import com.mrbysco.forcecraft.blockentities.AbstractForceFurnaceBlockEntity;
import com.mrbysco.forcecraft.blockentities.ForceFurnaceBlockEntity;
import com.mrbysco.forcecraft.items.UpgradeCoreItem;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.Random;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class ForceFurnaceBlock
extends AbstractFurnaceBlock
implements EntityBlock {
    private static final String NBT_UPGRADE = "upgrade";

    public ForceFurnaceBlock(BlockBehaviour.Properties builder) {
        super(builder);
    }

    public static ToIntFunction<BlockState> getLightValueLit(int lightValue) {
        return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? lightValue : 0;
    }

    protected void m_7137_(Level level, BlockPos pos, Player player) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof ForceFurnaceBlockEntity) {
            if (!level.f_46443_) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((ForceFurnaceBlockEntity)blockentity), (BlockPos)pos);
            }
            player.m_36220_(Stats.f_12966_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level level, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.m_61143_((Property)f_48684_)).booleanValue()) {
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = pos.m_123342_();
            double d2 = (double)pos.m_123343_() + 0.5;
            if (rand.nextDouble() < 0.1) {
                level.m_7785_(d0, d1, d2, SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)stateIn.m_61143_((Property)f_48683_);
            Direction.Axis direction$axis = direction.m_122434_();
            double d3 = 0.52;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * d3 : d4;
            double d6 = rand.nextDouble() * 6.0 / 16.0;
            double d7 = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * d3 : d4;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ForceFurnaceBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return ForceFurnaceBlock.createForceFurnaceTicker(level, blockEntityType, (BlockEntityType<? extends AbstractForceFurnaceBlockEntity>)((BlockEntityType)ForceRegistry.FURNACE_BLOCK_ENTITY.get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createForceFurnaceTicker(Level level, BlockEntityType<T> p_151989_, BlockEntityType<? extends AbstractForceFurnaceBlockEntity> abstractForceFurnaceType) {
        return level.f_46443_ ? null : ForceFurnaceBlock.m_152132_(p_151989_, abstractForceFurnaceType, AbstractForceFurnaceBlockEntity::serverTick);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity instanceof AbstractForceFurnaceBlockEntity) {
                AbstractForceFurnaceBlockEntity furnaceTile = (AbstractForceFurnaceBlockEntity)blockentity;
                for (int i = 0; i < furnaceTile.m_6643_(); ++i) {
                    if (furnaceTile.m_8020_(i).m_41720_() instanceof UpgradeCoreItem) continue;
                    ForceFurnaceBlock.spawnItemStack(level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), furnaceTile.m_8020_(i));
                }
                if (level instanceof ServerLevel) {
                    furnaceTile.getRecipesToAwardAndPopExperience((ServerLevel)level, Vec3.m_82512_((Vec3i)pos));
                }
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public static void spawnItemStack(Level level, double x, double y, double z, ItemStack stack) {
        double d0 = EntityType.f_20461_.m_20678_();
        double d1 = 1.0 - d0;
        double d2 = d0 / 2.0;
        double d3 = Math.floor(x) + level.f_46441_.m_188500_() * d1 + d2;
        double d4 = Math.floor(y) + level.f_46441_.m_188500_() * d1;
        double d5 = Math.floor(z) + level.f_46441_.m_188500_() * d1 + d2;
        while (!stack.m_41619_()) {
            ItemEntity itementity = new ItemEntity(level, d3, d4, d5, stack.m_41620_(level.f_46441_.m_188503_(21) + 10));
            float f = 0.05f;
            itementity.m_20334_(level.f_46441_.m_188583_() * (double)0.05f, level.f_46441_.m_188583_() * (double)f + (double)0.2f, level.f_46441_.m_188583_() * (double)f);
            level.m_7967_((Entity)itementity);
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof AbstractForceFurnaceBlockEntity) {
            AbstractForceFurnaceBlockEntity furnaceTile = (AbstractForceFurnaceBlockEntity)blockentity;
            if (stack.m_41788_()) {
                furnaceTile.m_58638_(stack.m_41786_());
            }
            if (stack.m_41783_() != null && stack.m_41783_().m_128441_(NBT_UPGRADE)) {
                ItemStack upgrade = ItemStack.m_41712_((CompoundTag)stack.m_41783_().m_128469_(NBT_UPGRADE));
                furnaceTile.setUpgrade(upgrade);
            }
        }
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        ForceFurnaceBlockEntity tile;
        super.m_6240_(level, player, pos, state, te, stack);
        if (te instanceof ForceFurnaceBlockEntity && !(tile = (ForceFurnaceBlockEntity)te).getUpgrade().m_41619_()) {
            level.m_5594_((Player)null, pos, SoundEvents.f_12018_, SoundSource.BLOCKS, 0.5f, 1.0f);
        }
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }
}

