/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra.recipe;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.api.fluid.IFluidStackHolder;
import cofh.lib.common.fluid.FluidIngredient;
import cofh.lib.common.fluid.FluidStackHolder;
import cofh.lib.util.crafting.ComparableItemStack;
import cofh.thermal.lib.util.managers.AbstractManager;
import cofh.thermal.lib.util.managers.IRecipeManager;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import cofh.thermal.lib.util.recipes.internal.IMachineRecipe;
import cofh.thermal.lib.util.recipes.internal.SimpleMachineRecipe;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mrthomas20121.thermal_extra.init.ThermalExtraRecipeTypes;
import mrthomas20121.thermal_extra.recipe.FluidMixerRecipe;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidMixerRecipeManager
extends AbstractManager
implements IRecipeManager {
    private static final FluidMixerRecipeManager INSTANCE = new FluidMixerRecipeManager();
    protected static final int DEFAULT_ENERGY = 6000;
    protected Map<Integer, IMachineRecipe> recipeMap = new Object2ObjectOpenHashMap();
    protected Set<Fluid> validLeftFluids = new ObjectOpenHashSet();
    protected Set<Fluid> validRightFluids = new ObjectOpenHashSet();
    protected Set<ComparableItemStack> validItems = new ObjectOpenHashSet();
    protected int maxOutputItems = 0;
    protected int maxOutputFluids = 2;

    public static FluidMixerRecipeManager instance() {
        return INSTANCE;
    }

    private FluidMixerRecipeManager() {
        super(6000);
    }

    protected void clear() {
        this.recipeMap.clear();
        this.validLeftFluids.clear();
        this.validItems.clear();
    }

    public boolean validFluid(FluidStack input) {
        return this.validLeftFluids.contains(input.getFluid());
    }

    public boolean validRightFluid(FluidStack input) {
        return this.validRightFluids.contains(input.getFluid());
    }

    protected IMachineRecipe getRecipe(FluidStack input1, FluidStack input2) {
        return this.getRecipe(List.of(new FluidStackHolder(input1), new FluidStackHolder(input2)));
    }

    protected IMachineRecipe getRecipe(List<? extends IFluidStackHolder> inputTanks) {
        if (inputTanks.isEmpty() || inputTanks.get(0).isEmpty() || inputTanks.get(1).isEmpty()) {
            return null;
        }
        FluidStack inputFluid1 = inputTanks.get(0).getFluidStack();
        FluidStack inputFluid2 = inputTanks.get(1).getFluidStack();
        return this.recipeMap.get(this.getHashCode(inputFluid1, inputFluid2));
    }

    public void addRecipe(ThermalRecipe recipe) {
        FluidStack[] fluids2;
        if (recipe.getInputFluids().isEmpty()) {
            return;
        }
        FluidIngredient ingredient1 = (FluidIngredient)recipe.getInputFluids().get(0);
        FluidIngredient ingredient2 = (FluidIngredient)recipe.getInputFluids().get(1);
        FluidStack[] fluids1 = ingredient1.getFluids();
        if (fluids1.length == (fluids2 = ingredient2.getFluids()).length) {
            for (int i = 0; i < fluids1.length; ++i) {
                FluidStack fluidStack1 = fluids1[i];
                FluidStack fluidStack2 = fluids2[i];
                Fluid fluid1 = fluidStack1.getFluid();
                Fluid fluid2 = fluidStack2.getFluid();
                this.validLeftFluids.add(fluid1);
                this.validRightFluids.add(fluid2);
                this.addRecipe(recipe.getEnergy(), recipe.getXp(), Collections.emptyList(), List.of(fluidStack1, fluidStack2), Collections.emptyList(), Collections.emptyList(), recipe.getOutputFluids());
            }
        } else if (fluids1.length > fluids2.length) {
            for (FluidStack fluidStack1 : fluids1) {
                for (FluidStack fluidStack2 : fluids2) {
                    Fluid fluid1 = fluidStack1.getFluid();
                    Fluid fluid2 = fluidStack2.getFluid();
                    this.validLeftFluids.add(fluid1);
                    this.validRightFluids.add(fluid2);
                    this.addRecipe(recipe.getEnergy(), recipe.getXp(), Collections.emptyList(), List.of(fluidStack1, fluidStack2), Collections.emptyList(), Collections.emptyList(), recipe.getOutputFluids());
                }
            }
        } else {
            for (FluidStack fluidStack2 : fluids2) {
                for (FluidStack fluidStack1 : fluids1) {
                    Fluid fluid1 = fluidStack1.getFluid();
                    Fluid fluid2 = fluidStack2.getFluid();
                    this.validLeftFluids.add(fluid1);
                    this.validRightFluids.add(fluid2);
                    this.addRecipe(recipe.getEnergy(), recipe.getXp(), Collections.emptyList(), List.of(fluidStack1, fluidStack2), Collections.emptyList(), Collections.emptyList(), recipe.getOutputFluids());
                }
            }
        }
    }

    protected IMachineRecipe addRecipe(int energy, float experience, List<ItemStack> inputItems, List<FluidStack> inputFluids, List<ItemStack> outputItems, List<Float> chance, List<FluidStack> outputFluids) {
        if (inputFluids.isEmpty() || outputItems.isEmpty() && outputFluids.isEmpty() || outputItems.size() > this.maxOutputItems || outputFluids.size() > this.maxOutputFluids || energy <= 0) {
            return null;
        }
        FluidStack input1 = inputFluids.get(0);
        FluidStack input2 = inputFluids.get(1);
        if (input1.isEmpty() || input2.isEmpty()) {
            return null;
        }
        for (FluidStack stack : outputFluids) {
            if (!stack.isEmpty()) continue;
            return null;
        }
        energy = (int)((float)energy * this.getDefaultScale());
        SimpleMachineRecipe recipe = new SimpleMachineRecipe(energy, experience, inputItems, inputFluids, outputItems, chance, outputFluids);
        this.recipeMap.put(this.getHashCode(input1, input2), (IMachineRecipe)recipe);
        return recipe;
    }

    private int getHashCode(FluidStack fluid1, FluidStack fluid2) {
        return FluidHelper.fluidHashcode((FluidStack)fluid1) + FluidHelper.fluidHashcode((FluidStack)fluid2);
    }

    public IMachineRecipe getRecipe(IThermalInventory inventory) {
        return this.getRecipe(inventory.inputTanks());
    }

    public List<IMachineRecipe> getRecipeList() {
        return new ArrayList<IMachineRecipe>(this.recipeMap.values());
    }

    public void refresh(RecipeManager recipeManager) {
        this.clear();
        List recipes = recipeManager.m_44013_((RecipeType)ThermalExtraRecipeTypes.FLUID_MIXER.get());
        for (FluidMixerRecipe entry : recipes) {
            this.addRecipe(entry);
        }
    }
}

