/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra.init;

import cofh.core.common.block.EntityBlockActive4Way;
import cofh.core.common.item.ItemCoFH;
import cofh.lib.util.DeferredRegisterCoFH;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.BlockStatePropertiesCoFH;
import cofh.lib.util.helpers.BlockHelper;
import cofh.thermal.core.common.block.HardenedGlassBlock;
import cofh.thermal.core.common.config.ThermalCoreConfig;
import cofh.thermal.lib.common.block.DynamoBlock;
import cofh.thermal.lib.common.item.BlockItemAugmentable;
import cofh.thermal.lib.util.ThermalAugmentRules;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import mrthomas20121.thermal_extra.block.entity.DeviceHarvesterBlockEntity;
import mrthomas20121.thermal_extra.block.entity.DeviceLavaGenBlockEntity;
import mrthomas20121.thermal_extra.block.entity.DynamoColdBlockEntity;
import mrthomas20121.thermal_extra.block.entity.MachineAdvancedRefineryBlockEntity;
import mrthomas20121.thermal_extra.block.entity.MachineComponentAssemblyBlockEntity;
import mrthomas20121.thermal_extra.block.entity.MachineEndothermicDehydratorBlockEntity;
import mrthomas20121.thermal_extra.block.entity.MachineFluidMixerBlockEntity;
import mrthomas20121.thermal_extra.block.entity.MachineNitraticIgniterBlockEntity;
import mrthomas20121.thermal_extra.init.ThermalExtraBlockEntities;
import mrthomas20121.thermal_extra.init.ThermalExtraItems;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ThermalExtraBlocks {
    public static DeferredRegisterCoFH<Block> BLOCKS = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"thermal_extra");
    public static RegistryObject<Block> SOUL_INFUSED_BLOCK = ThermalExtraBlocks.register("soul_infused_block");
    public static RegistryObject<Block> SHELLITE_BLOCK = ThermalExtraBlocks.register("shellite_block");
    public static RegistryObject<Block> TWINITE_BLOCK = ThermalExtraBlocks.register("twinite_block");
    public static RegistryObject<Block> DRAGONSTEEL_BLOCK = ThermalExtraBlocks.register("dragonsteel_block");
    public static RegistryObject<Block> ABYSSAL_BLOCK = ThermalExtraBlocks.register("abyssal_block");
    public static RegistryObject<Block> SOUL_INFUSED_GLASS = ThermalExtraBlocks.registerGlass("soul_infused_glass");
    public static RegistryObject<Block> SHELLITE_GLASS = ThermalExtraBlocks.registerGlass("shellite_glass");
    public static RegistryObject<Block> TWINITE_GLASS = ThermalExtraBlocks.registerGlass("twinite_glass");
    public static RegistryObject<Block> DRAGONSTEEL_GLASS = ThermalExtraBlocks.registerGlass("dragonsteel_glass");
    public static RegistryObject<Block> ABYSSAL_GLASS = ThermalExtraBlocks.registerGlass("abyssal_glass");
    public static RegistryObject<DynamoBlock> DYNAMO_COLD = BLOCKS.register("dynamo_frost", () -> new DynamoBlock(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56725_).m_60978_(2.0f).m_60953_(BlockHelper.lightValue((BooleanProperty)BlockStatePropertiesCoFH.ACTIVE, (int)7)), DynamoColdBlockEntity.class, ThermalExtraBlockEntities.DYNAMO_COLD));
    public static RegistryObject<Item> ADVANCED_REFINERY = ThermalExtraBlocks.registerAugmentableBlock("advanced_refinery", () -> new EntityBlockActive4Way(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56725_).m_60978_(2.0f).m_60953_(BlockHelper.lightValue((BooleanProperty)BlockStatePropertiesCoFH.ACTIVE, (int)5)), MachineAdvancedRefineryBlockEntity.class, ThermalExtraBlockEntities.ADVANCED_REFINERY), () -> ThermalCoreConfig.machineAugments, ThermalAugmentRules.MACHINE_VALIDATOR, "thermal_extra");
    public static RegistryObject<Item> NITRATIC_IGNITER = ThermalExtraBlocks.registerAugmentableBlock("nitratic_igniter", () -> new EntityBlockActive4Way(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56725_).m_60978_(2.0f).m_60953_(BlockHelper.lightValue((BooleanProperty)BlockStatePropertiesCoFH.ACTIVE, (int)0)), MachineNitraticIgniterBlockEntity.class, ThermalExtraBlockEntities.NITRATIC_IGNITER), () -> ThermalCoreConfig.machineAugments, ThermalAugmentRules.MACHINE_VALIDATOR, "thermal_extra");
    public static RegistryObject<Item> FLUID_MIXER = ThermalExtraBlocks.registerAugmentableBlock("fluid_mixer", () -> new EntityBlockActive4Way(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56725_).m_60978_(2.0f).m_60953_(BlockHelper.lightValue((BooleanProperty)BlockStatePropertiesCoFH.ACTIVE, (int)0)), MachineFluidMixerBlockEntity.class, ThermalExtraBlockEntities.FLUID_MIXER), () -> ThermalCoreConfig.machineAugments, ThermalAugmentRules.MACHINE_VALIDATOR, "thermal_extra");
    public static RegistryObject<Item> COMPONENT_ASSEMBLY = ThermalExtraBlocks.registerAugmentableBlock("component_assembly", () -> new EntityBlockActive4Way(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56725_).m_60978_(2.0f).m_60953_(BlockHelper.lightValue((BooleanProperty)BlockStatePropertiesCoFH.ACTIVE, (int)0)), MachineComponentAssemblyBlockEntity.class, ThermalExtraBlockEntities.COMPONENT_ASSEMBLY), () -> ThermalCoreConfig.machineAugments, ThermalAugmentRules.MACHINE_VALIDATOR, "thermal_extra");
    public static RegistryObject<Item> ENDOTHERMIC_DEHYDRATOR = ThermalExtraBlocks.registerAugmentableBlock("endothermic_dehydrator", () -> new EntityBlockActive4Way(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56725_).m_60978_(2.0f).m_60953_(BlockHelper.lightValue((BooleanProperty)BlockStatePropertiesCoFH.ACTIVE, (int)0)), MachineEndothermicDehydratorBlockEntity.class, ThermalExtraBlockEntities.ENDOTHERMIC_DEHYDRATOR), () -> ThermalCoreConfig.machineAugments, ThermalAugmentRules.MACHINE_VALIDATOR, "thermal_extra");
    public static RegistryObject<Item> LAVA_GEN = ThermalExtraBlocks.registerAugmentableBlock("device_lava_gen", () -> new EntityBlockActive4Way(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56762_).m_60978_(2.0f), DeviceLavaGenBlockEntity.class, ThermalExtraBlockEntities.LAVA_GEN), () -> ThermalCoreConfig.deviceAugments, DeviceLavaGenBlockEntity.AUG_VALIDATOR);
    public static RegistryObject<Item> HARVESTER = ThermalExtraBlocks.registerAugmentableBlock("device_harvester", () -> new EntityBlockActive4Way(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_244244_).m_60978_(2.0f), DeviceHarvesterBlockEntity.class, ThermalExtraBlockEntities.HARVESTER), () -> ThermalCoreConfig.deviceAugments, DeviceHarvesterBlockEntity.AUG_VALIDATOR);

    private static Rarity getRarity(String name) {
        if (name.contains("shellite")) {
            return ThermalExtraItems.dark_purple;
        }
        if (name.contains("twinite")) {
            return ThermalExtraItems.red;
        }
        if (name.contains("dragonsteel")) {
            return ThermalExtraItems.dark_aqua;
        }
        if (name.contains("abyssal")) {
            return ThermalExtraItems.green;
        }
        return ThermalExtraItems.yellow;
    }

    public static RegistryObject<Block> registerGlass(String name) {
        RegistryObject block = BLOCKS.register(name, () -> new HardenedGlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60922_(ThermalExtraBlocks::neverAllowSpawn).m_60924_(ThermalExtraBlocks::isNotSolid).m_60960_(ThermalExtraBlocks::isNotSolid).m_60971_(ThermalExtraBlocks::isNotSolid)));
        Rarity rarity = ThermalExtraBlocks.getRarity(name);
        ThermalExtraItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41497_(rarity)));
        return block;
    }

    public static RegistryObject<Block> register(String name) {
        RegistryObject block = BLOCKS.register(name, () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60913_(5.0f, 5.0f).m_60918_(SoundType.f_56743_)));
        Rarity rarity = ThermalExtraBlocks.getRarity(name);
        ThermalExtraItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41497_(rarity)));
        return block;
    }

    private static Boolean neverAllowSpawn(BlockState state, BlockGetter reader, BlockPos pos, EntityType<?> entity) {
        return false;
    }

    private static boolean isNotSolid(BlockState state, BlockGetter reader, BlockPos pos) {
        return false;
    }

    public static RegistryObject<Item> registerAugmentableBlock(String name, Supplier<Block> sup, IntSupplier numSlots, BiPredicate<ItemStack, List<ItemStack>> validAugment) {
        return ThermalExtraBlocks.registerAugmentableBlock(name, sup, numSlots, validAugment, "thermal");
    }

    public static RegistryObject<Item> registerAugmentableBlock(String name, Supplier<Block> sup, IntSupplier numSlots, BiPredicate<ItemStack, List<ItemStack>> validAugment, String modId) {
        return ThermalExtraBlocks.registerAugmentableBlock(name, sup, numSlots, validAugment, Rarity.COMMON, modId);
    }

    public static RegistryObject<Item> registerAugmentableBlock(String name, Supplier<Block> sup, IntSupplier numSlots, BiPredicate<ItemStack, List<ItemStack>> validAugment, Rarity rarity, String modId) {
        BLOCKS.register(name, sup);
        return ThermalExtraBlocks.registerItem(name, () -> new BlockItemAugmentable((Block)BLOCKS.get(name), Utils.itemProperties().m_41497_(rarity)).setNumSlots(numSlots).setAugValidator(validAugment).setModId(modId));
    }

    public static RegistryObject<Item> registerItem(String name, Supplier<Item> sup) {
        return ThermalExtraItems.ITEMS.register(name, sup);
    }

    public static RegistryObject<Item> registerItem(String name) {
        return ThermalExtraBlocks.registerItem(name, Rarity.COMMON);
    }

    public static RegistryObject<Item> registerItem(String name, Rarity rarity) {
        return ThermalExtraBlocks.registerItem(name, () -> new ItemCoFH(Utils.itemProperties().m_41497_(rarity)));
    }
}

