/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slope;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;
import xfacthd.framedblocks.common.data.shapes.slope.SlopeShapes;

public final class ThreewayCornerShapes
implements SplitShapeGenerator {
    public static final ThreewayCornerShapes OUTER = new ThreewayCornerShapes(BooleanOp.f_82689_);
    public static final ThreewayCornerShapes INNER = new ThreewayCornerShapes(BooleanOp.f_82695_);
    private final BooleanOp joinOp;

    private ThreewayCornerShapes(BooleanOp joinOp) {
        this.joinOp = joinOp;
    }

    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return this.generate(states, SlopeShapes.SHAPES);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return this.generate(states, SlopeShapes.OCCLUSION_SHAPES);
    }

    private ShapeProvider generate(ImmutableList<BlockState> states, ShapeCache<SlopeType> shapeCache) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeTop = Shapes.m_83148_((VoxelShape)Shapes.m_83148_((VoxelShape)shapeCache.get(SlopeType.TOP), (VoxelShape)shapeCache.get(SlopeType.HORIZONTAL), (BooleanOp)this.joinOp), (VoxelShape)ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, shapeCache.get(SlopeType.TOP)), (BooleanOp)this.joinOp);
        VoxelShape shapeBottom = Shapes.m_83148_((VoxelShape)Shapes.m_83148_((VoxelShape)shapeCache.get(SlopeType.BOTTOM), (VoxelShape)shapeCache.get(SlopeType.HORIZONTAL), (BooleanOp)this.joinOp), (VoxelShape)ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, shapeCache.get(SlopeType.BOTTOM)), (BooleanOp)this.joinOp);
        VoxelShape[] shapes = ShapeUtils.makeHorizontalRotationsWithFlag(shapeBottom, shapeTop, Direction.NORTH);
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            builder.put((Object)state, (Object)shapes[dir.m_122416_() + (top ? 4 : 0)]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

