/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.camo;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.camo.ContainerType;
import xfacthd.framedblocks.api.camo.EmptyCamoContainer;
import xfacthd.framedblocks.api.util.ClientUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;

public class FluidCamoContainer
extends CamoContainer {
    private final FluidState fluidState;

    private FluidCamoContainer(FluidState fluidState) {
        super(fluidState.m_76188_());
        this.fluidState = fluidState;
    }

    @Override
    public int getColor(BlockAndTintGetter level, BlockPos pos, int tintIdx) {
        if (FMLEnvironment.dist.isClient()) {
            return ClientUtils.getFluidColor(level, pos, this.fluidState);
        }
        throw new UnsupportedOperationException("Block color is not available on the server!");
    }

    @Override
    public ItemStack toItemStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        LazyOptional cap = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
        return cap.map(handler -> {
            FluidStack fluid = new FluidStack(this.fluidState.m_76152_(), 1000);
            if (handler.fill(fluid, IFluidHandler.FluidAction.SIMULATE) == 1000) {
                handler.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                return handler.getContainer();
            }
            return ItemStack.f_41583_;
        }).orElse(ItemStack.f_41583_);
    }

    @Override
    public Fluid getFluid() {
        return this.fluidState.m_76152_();
    }

    @Override
    public boolean canRotateCamo() {
        return false;
    }

    @Override
    public boolean rotateCamo() {
        return false;
    }

    @Override
    public SoundType getSoundType() {
        return super.getSoundType();
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.state == ((CamoContainer)o).getState();
    }

    public int hashCode() {
        return this.state.hashCode();
    }

    @Override
    public ContainerType getType() {
        return ContainerType.FLUID;
    }

    @Override
    public CamoContainer.Factory getFactory() {
        return (CamoContainer.Factory)FBContent.FACTORY_FLUID.get();
    }

    @Override
    public void save(CompoundTag tag) {
        tag.m_128365_("fluid", (Tag)NbtUtils.m_178022_((FluidState)this.fluidState));
    }

    @Override
    public void toNetwork(CompoundTag tag) {
        tag.m_128405_("fluid", Utils.getId(ForgeRegistries.FLUIDS, this.fluidState.m_76152_()));
    }

    public static final class Factory
    extends CamoContainer.Factory {
        @Override
        public CamoContainer fromNbt(CompoundTag tag) {
            FluidState fluidState = Utils.readFluidStateFromNbt(tag.m_128469_("fluid"));
            return new FluidCamoContainer(fluidState);
        }

        @Override
        public CamoContainer fromNetwork(CompoundTag tag) {
            FluidState fluidState = ((Fluid)Utils.getValue(ForgeRegistries.FLUIDS, tag.m_128451_("fluid"))).m_76145_();
            return new FluidCamoContainer(fluidState);
        }

        @Override
        public CamoContainer fromItem(ItemStack stack) {
            LazyOptional cap = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
            return cap.map(handler -> {
                FluidStack fluid = handler.getFluidInTank(0);
                FluidState state = fluid.getFluid().m_76145_();
                if (!state.m_76178_() && !state.m_76188_().m_60795_()) {
                    int amount = 1000;
                    if (fluid.getAmount() >= amount && handler.drain(amount, IFluidHandler.FluidAction.SIMULATE).getAmount() == amount) {
                        return new FluidCamoContainer(state);
                    }
                }
                return EmptyCamoContainer.EMPTY;
            }).orElse(EmptyCamoContainer.EMPTY);
        }
    }
}

