/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.rail;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.IFramedDoubleBlock;
import xfacthd.framedblocks.common.block.ISlopeBlock;
import xfacthd.framedblocks.common.block.rail.FramedDetectorRailSlopeBlock;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.FramedDoubleBlockRenderProperties;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.util.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.util.FramedUtils;

class FramedFancyDetectorRailSlopeBlock
extends FramedDetectorRailSlopeBlock
implements IFramedDoubleBlock,
ISlopeBlock.IRailSlopeBlock {
    FramedFancyDetectorRailSlopeBlock(BlockType type, BiFunction<BlockPos, BlockState, FramedBlockEntity> beFactory) {
        super(type, beFactory);
    }

    @Override
    @Nullable
    public BlockState runOcclusionTestAndGetLookupState(SideSkipPredicate pred, BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        Tuple statePair = this.getBlockPair(adjState);
        return super.runOcclusionTestAndGetLookupState(pred, level, pos, state, (BlockState)statePair.m_14418_(), side);
    }

    @Override
    @Nullable
    public BlockState getComponentBySkipPredicate(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction side) {
        BlockState slopeState = (BlockState)this.getBlockPair(state).m_14418_();
        if (IFramedDoubleBlock.testComponent(level, pos, slopeState, neighborState, side)) {
            return slopeState;
        }
        return null;
    }

    @Override
    public ModelData unpackNestedModelData(ModelData data, BlockState state, BlockState componentState) {
        return Objects.requireNonNullElse((ModelData)data.get(FramedDoubleBlockEntity.DATA_LEFT), ModelData.EMPTY);
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        return DoubleBlockTopInteractionMode.FIRST;
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        RailShape shape = (RailShape)state.m_61143_(PropertyHolder.ASCENDING_RAIL_SHAPE);
        boolean ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
        Direction facing = FramedUtils.getDirectionFromAscendingRailShape(shape);
        return new Tuple((Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLOPE.get()).m_49966_().m_61124_(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)SlopeType.BOTTOM))).m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))), (Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_FANCY_DETECTOR_RAIL.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61404_, (Comparable)shape)));
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction facing = this.getFacing(state);
        if (side == facing || side == Direction.DOWN) {
            return CamoGetter.FIRST;
        }
        if (!(side.m_122434_() == facing.m_122434_() || Utils.isY(side) || edge != facing && edge != Direction.DOWN)) {
            return CamoGetter.FIRST;
        }
        return CamoGetter.NONE;
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        if (side == Direction.DOWN || side == this.getFacing(state)) {
            return SolidityCheck.FIRST;
        }
        return SolidityCheck.NONE;
    }

    @Override
    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(FramedDoubleBlockRenderProperties.INSTANCE);
    }
}

