/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.pillar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import net.minecraftforge.fml.loading.FMLEnvironment;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.render.FramedBlockRenderProperties;
import xfacthd.framedblocks.api.shapes.ReloadableShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeGenerator;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedWallBlock
extends WallBlock
implements IFramedBlock {
    private final ShapeProvider shapes = this.makeShapeProvider(states -> FramedWallBlock.generateShapes((ImmutableList<BlockState>)states, 14.0f, 16.0f));
    private final ShapeProvider collisionShapes = this.makeShapeProvider(states -> FramedWallBlock.generateShapes((ImmutableList<BlockState>)states, 24.0f, 24.0f));

    public FramedWallBlock() {
        super(IFramedBlock.createProperties(BlockType.FRAMED_WALL));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.STATE_LOCKED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.GLOWING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.PROPAGATES_SKYLIGHT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.STATE_LOCKED, FramedProperties.GLOWING, FramedProperties.PROPAGATES_SKYLIGHT});
    }

    public final InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.handleUse(state, level, pos, player, hand, hit);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryApplyCamoImmediately(level, pos, placer, stack);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        BlockState newState = this.updateShapeLockable(state, level, currentPos, () -> super.m_7417_(state, facing, facingState, level, currentPos, facingPos));
        if (newState == state) {
            this.updateCulling((LevelReader)level, currentPos);
        }
        return newState;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        this.updateCulling((LevelReader)level, pos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.shapes.get(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.collisionShapes.get(state);
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamoShadeBrightness(state, level, pos, super.m_7749_(state, level, pos));
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)FramedProperties.PROPAGATES_SKYLIGHT);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        return this.getCamoDrops(super.m_49635_(state, builder), builder);
    }

    @Override
    public boolean doesBlockOccludeBeaconBeam(BlockState state, LevelReader level, BlockPos pos) {
        return true;
    }

    @Override
    public BlockType getBlockType() {
        return BlockType.FRAMED_WALL;
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(FramedBlockRenderProperties.INSTANCE);
    }

    protected Map<BlockState, VoxelShape> m_57965_(float pWidth, float pDepth, float pWallPostHeight, float pWallMinY, float pWallLowHeight, float pWallTallHeight) {
        return Map.of();
    }

    private ShapeProvider makeShapeProvider(ShapeGenerator generator) {
        ImmutableList states = this.f_49792_.m_61056_();
        if (!FMLEnvironment.production) {
            return new ReloadableShapeProvider(generator, (ImmutableList<BlockState>)states);
        }
        return generator.generate((ImmutableList<BlockState>)states);
    }

    private static ShapeProvider generateShapes(ImmutableList<BlockState> states, float lowHeight, float tallHeight) {
        boolean sameHeight = lowHeight == tallHeight;
        VoxelShape centerLowShape = FramedWallBlock.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)lowHeight, (double)11.0);
        VoxelShape centerTallShape = sameHeight ? centerLowShape : FramedWallBlock.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)tallHeight, (double)11.0);
        VoxelShape postShape = FramedWallBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)tallHeight, (double)12.0);
        VoxelShape wallLowShape = FramedWallBlock.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)lowHeight, (double)5.0);
        VoxelShape wallTallShape = sameHeight ? wallLowShape : FramedWallBlock.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)tallHeight, (double)5.0);
        VoxelShape[] wallLowShapes = ShapeUtils.makeHorizontalRotations(wallLowShape, Direction.NORTH);
        VoxelShape[] wallTallShapes = sameHeight ? wallLowShapes : ShapeUtils.makeHorizontalRotations(wallTallShape, Direction.NORTH);
        VoxelShape[] shapes = new VoxelShape[512];
        for (WallSide north : f_57951_.m_6908_()) {
            for (WallSide east : f_57950_.m_6908_()) {
                for (WallSide south : f_57952_.m_6908_()) {
                    for (WallSide west : f_57953_.m_6908_()) {
                        int noUpKey = FramedWallBlock.makeShapeKey(false, north, east, south, west);
                        int upKey = FramedWallBlock.makeShapeKey(true, north, east, south, west);
                        boolean anyTall = north == WallSide.TALL || east == WallSide.TALL || south == WallSide.TALL || west == WallSide.TALL;
                        shapes[noUpKey] = ShapeUtils.or(anyTall ? centerTallShape : centerLowShape, FramedWallBlock.getWallShape(north, Direction.NORTH, wallLowShapes, wallTallShapes), FramedWallBlock.getWallShape(east, Direction.EAST, wallLowShapes, wallTallShapes), FramedWallBlock.getWallShape(south, Direction.SOUTH, wallLowShapes, wallTallShapes), FramedWallBlock.getWallShape(west, Direction.WEST, wallLowShapes, wallTallShapes));
                        shapes[upKey] = ShapeUtils.or(postShape, FramedWallBlock.getWallShape(north, Direction.NORTH, wallLowShapes, wallTallShapes), FramedWallBlock.getWallShape(east, Direction.EAST, wallLowShapes, wallTallShapes), FramedWallBlock.getWallShape(south, Direction.SOUTH, wallLowShapes, wallTallShapes), FramedWallBlock.getWallShape(west, Direction.WEST, wallLowShapes, wallTallShapes));
                    }
                }
            }
        }
        shapes[0] = Shapes.m_83144_();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            int key = FramedWallBlock.makeShapeKey((Boolean)state.m_61143_((Property)f_57949_), (WallSide)state.m_61143_((Property)f_57951_), (WallSide)state.m_61143_((Property)f_57950_), (WallSide)state.m_61143_((Property)f_57952_), (WallSide)state.m_61143_((Property)f_57953_));
            builder.put((Object)state, (Object)shapes[key]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private static VoxelShape getWallShape(WallSide side, Direction dir, VoxelShape[] lowShapes, VoxelShape[] tallShapes) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case WallSide.NONE -> Shapes.m_83040_();
            case WallSide.LOW -> lowShapes[dir.m_122416_()];
            case WallSide.TALL -> tallShapes[dir.m_122416_()];
        };
    }

    private static int makeShapeKey(boolean up, WallSide north, WallSide east, WallSide south, WallSide west) {
        return (up ? 1 : 0) << 8 | north.ordinal() << 6 | east.ordinal() << 4 | south.ordinal() << 2 | west.ordinal();
    }
}

