/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.screen.overlay;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.screen.overlay.BlockInteractOverlay;
import xfacthd.framedblocks.client.util.ClientConfig;

public final class ReinforcementOverlay
extends BlockInteractOverlay {
    public static final String REINFORCE_MESSAGE = Utils.translationKey("tooltip", "reinforce_state");
    public static final Component STATE_NOT_REINFORCED = Utils.translate("tooltip", "reinforce_state.false").m_130940_(ChatFormatting.RED);
    public static final Component STATE_REINFORCED = Utils.translate("tooltip", "reinforce_state.true").m_130940_(ChatFormatting.GREEN);
    private static final List<Component> LIST_FALSE = List.of(Component.m_237110_((String)REINFORCE_MESSAGE, (Object[])new Object[]{STATE_NOT_REINFORCED}));
    private static final List<Component> LIST_TRUE = List.of(Component.m_237110_((String)REINFORCE_MESSAGE, (Object[])new Object[]{STATE_REINFORCED}));
    private static final ResourceLocation SYMBOL_TEXTURE = Utils.rl("textures/overlay/reinforcement_symbols.png");
    private static final BlockInteractOverlay.Texture TEXTURE_FALSE = new BlockInteractOverlay.Texture(SYMBOL_TEXTURE, 0, 0, 22, 22, 44, 22);
    private static final BlockInteractOverlay.Texture TEXTURE_TRUE = new BlockInteractOverlay.Texture(SYMBOL_TEXTURE, 22, 0, 22, 22, 44, 22);

    public ReinforcementOverlay() {
        super(LIST_FALSE, LIST_TRUE, TEXTURE_FALSE, TEXTURE_TRUE, () -> ClientConfig.reinforcementMode);
    }

    @Override
    protected boolean isValidTool(ItemStack stack) {
        return stack.m_150930_((Item)Utils.FRAMED_REINFORCEMENT.get());
    }

    @Override
    protected boolean isValidTarget(BlockInteractOverlay.Target target) {
        return target.state().m_60734_() instanceof IFramedBlock;
    }

    @Override
    protected boolean getState(BlockInteractOverlay.Target target) {
        BlockEntity blockEntity = ReinforcementOverlay.level().m_7702_(target.pos());
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.isReinforced();
        }
        return false;
    }
}

