/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.utils;

import codechicken.lib.util.ArrayUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;

public class DataUtils {
    public static String[] arrayToLowercase(String[] array) {
        String[] lowercaseArray = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            lowercaseArray[i] = array[i].toLowerCase(Locale.ENGLISH);
        }
        return lowercaseArray;
    }

    public static String[] arrayToString(Object[] array) {
        String[] lowercaseArray = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            lowercaseArray[i] = String.valueOf(array[i]);
        }
        return lowercaseArray;
    }

    public static String[] arrayToString(byte[] array) {
        String[] lowercaseArray = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            lowercaseArray[i] = String.valueOf(array[i]);
        }
        return lowercaseArray;
    }

    public static String[] arrayToString(int[] array) {
        String[] lowercaseArray = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            lowercaseArray[i] = String.valueOf(array[i]);
        }
        return lowercaseArray;
    }

    public static String stringArrayConcat(String[] array, String separator) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            s.append(array[i]);
            if (i + 1 >= array.length) continue;
            s.append(separator);
        }
        return s.toString();
    }

    public static Object[] arrayShift(Object[] input, int shift) {
        Object[] newArray = new Object[input.length];
        for (int i = 0; i < input.length; ++i) {
            int newPos = (i + shift) % input.length;
            if (newPos < 0) {
                newPos += input.length;
            }
            newArray[newPos] = input[i];
        }
        return newArray;
    }

    public static <T> int count(Iterable<T> iterable, Function<T, Boolean> check) {
        int counter = 0;
        for (T value : iterable) {
            if (!check.apply(value).booleanValue()) continue;
            ++counter;
        }
        return counter;
    }

    public static <T> int count(T[] iterable, Function<T, Boolean> check) {
        return ArrayUtils.count((Object[])iterable, check);
    }

    public static <E> void forEach(E[] elements, Consumer<E> consumer) {
        for (E element : elements) {
            consumer.accept(element);
        }
    }

    public static <E> void forEachMatch(E[] elements, Predicate<E> matcher, Consumer<E> consumer) {
        for (E element : elements) {
            if (!matcher.test(element)) continue;
            consumer.accept(element);
        }
    }

    public static <E> void forEachMatch(Iterable<E> elements, Predicate<E> matcher, Consumer<E> consumer) {
        for (E element : elements) {
            if (!matcher.test(element)) continue;
            consumer.accept(element);
        }
    }

    public static <E> void addIf(Iterable<E> elements, Collection<E> addTo, Predicate<E> matcher) {
        for (E element : elements) {
            if (!matcher.test(element)) continue;
            addTo.add(element);
        }
    }

    public static <E> E firstMatch(Iterable<E> elements, Predicate<E> matcher) {
        for (E element : elements) {
            if (!matcher.test(element)) continue;
            return element;
        }
        return null;
    }

    public static <E> boolean contains(E[] elements, Predicate<E> matcher) {
        for (E element : elements) {
            if (!matcher.test(element)) continue;
            return true;
        }
        return false;
    }

    public static long[] toPrimitive(Long[] array) {
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static int[] toPrimitive(Integer[] array) {
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static short[] toPrimitive(Short[] array) {
        short[] result = new short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static byte[] toPrimitive(Byte[] array) {
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static double[] toPrimitive(Double[] array) {
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static float[] toPrimitive(Float[] array) {
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].floatValue();
        }
        return result;
    }

    public static boolean[] toPrimitive(Boolean[] array) {
        boolean[] result = new boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static long[] longListToArray(List<Long> list) {
        long[] result = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static int[] intListToArray(List<Integer> list) {
        int[] result = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static short[] shortListToArray(List<Short> list) {
        short[] result = new short[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static byte[] byteListToArray(List<Byte> list) {
        byte[] result = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static double[] doubleListToArray(List<Double> list) {
        double[] result = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static float[] floatListToArray(List<Float> list) {
        float[] result = new float[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i).floatValue();
        }
        return result;
    }

    public static boolean[] boolListToArray(List<Boolean> list) {
        boolean[] result = new boolean[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static int formatColour(ChatFormatting formatting) {
        switch (formatting) {
            case BLACK: {
                return 0;
            }
            case DARK_BLUE: {
                return 170;
            }
            case DARK_GREEN: {
                return 43520;
            }
            case DARK_AQUA: {
                return 43690;
            }
            case DARK_RED: {
                return 0xAA0000;
            }
            case DARK_PURPLE: {
                return 0xAA00AA;
            }
            case GOLD: {
                return 0xFFAA00;
            }
            case GRAY: {
                return 0xAAAAAA;
            }
            case DARK_GRAY: {
                return 0x555555;
            }
            case BLUE: {
                return 0x5555FF;
            }
            case GREEN: {
                return 0x55FF55;
            }
            case AQUA: {
                return 0x55FFFF;
            }
            case RED: {
                return 0xFF5555;
            }
            case LIGHT_PURPLE: {
                return 0xFF55FF;
            }
            case YELLOW: {
                return 0xFFFF55;
            }
            case WHITE: {
                return 0xFFFFFF;
            }
        }
        return 0xFFFFFF;
    }

    public static long averageLongArray(long[] array) {
        long average = 0L;
        double remainder = 0.0;
        int count = array.length;
        for (long val : array) {
            average += val / (long)count;
            remainder += (double)val % (double)count / (double)count;
        }
        return average + (long)remainder;
    }

    public static <T> Set<T> concatSets(Set<T> ... sets) {
        HashSet<T> returnSet = new HashSet<T>();
        for (Set<T> set : sets) {
            returnSet.addAll(set);
        }
        return returnSet;
    }

    public static <T> boolean contains(Iterable<T> heldEquipment, T test) {
        for (T t : heldEquipment) {
            if (t != test) continue;
            return true;
        }
        return false;
    }

    public static <T> T safeRemove(List<T> list, int removeIndex) {
        if (removeIndex >= 0 && removeIndex < list.size()) {
            return list.remove(removeIndex);
        }
        return null;
    }

    public static <T> T safeGet(List<T> list, int getIndex) {
        if (getIndex >= 0 && getIndex < list.size()) {
            return list.get(getIndex);
        }
        return null;
    }

    public static <T> T safeGet(List<T> list, int getIndex, Supplier<T> orDefault) {
        if (getIndex >= 0 && getIndex < list.size()) {
            return list.get(getIndex);
        }
        return orDefault.get();
    }

    public static <T> void ifPresent(List<T> list, int index, Consumer<T> callback) {
        if (index >= 0 && index < list.size()) {
            callback.accept(list.get(index));
        }
    }
}

