/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.entityfilter;

import com.brandon3055.brandonscore.lib.entityfilter.EntityFilter;
import com.brandon3055.brandonscore.lib.entityfilter.FilterAdults;
import com.brandon3055.brandonscore.lib.entityfilter.FilterBase;
import com.brandon3055.brandonscore.lib.entityfilter.FilterEntity;
import com.brandon3055.brandonscore.lib.entityfilter.FilterGroup;
import com.brandon3055.brandonscore.lib.entityfilter.FilterHostile;
import com.brandon3055.brandonscore.lib.entityfilter.FilterItem;
import com.brandon3055.brandonscore.lib.entityfilter.FilterPlayer;
import com.brandon3055.brandonscore.lib.entityfilter.FilterTamed;
import java.util.function.Function;

public enum FilterType {
    HOSTILE(0, FilterHostile::new),
    TAMED(1, FilterTamed::new),
    ADULTS(2, FilterAdults::new),
    PLAYER(3, FilterPlayer::new),
    ENTITY_TYPE(4, FilterEntity::new),
    ITEM_FILTER(5, FilterItem::new),
    FILTER_GROUP(6, FilterGroup::new);

    public final int index;
    private final Function<EntityFilter, FilterBase> nodeBuilder;
    public static final FilterType[] filterTypeMap;

    private FilterType(int index, Function<EntityFilter, FilterBase> nodeSupplier) {
        this.index = index;
        this.nodeBuilder = nodeSupplier;
    }

    public FilterBase createNode(EntityFilter filter) {
        return this.nodeBuilder.apply(filter);
    }

    static {
        filterTypeMap = new FilterType[FilterType.values().length];
        FilterType[] filterTypeArray = FilterType.values();
        int n = filterTypeArray.length;
        for (int i = 0; i < n; ++i) {
            FilterType type;
            FilterType.filterTypeMap[type.index] = type = filterTypeArray[i];
        }
    }
}

