/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;

public class ManagedShort
extends AbstractManagedData<Short> {
    private short value;
    protected Function<Short, Short> validator = null;

    public ManagedShort(String name, short defaultValue, DataFlags ... flags) {
        super(name, flags);
        this.value = defaultValue;
    }

    public ManagedShort(String name, DataFlags ... flags) {
        this(name, 0, flags);
    }

    public short set(short value) {
        if (!Objects.equals(this.value, value)) {
            boolean set = true;
            short prev = this.value;
            this.value = value;
            if (this.dataManager.isClientSide() && this.flags.allowClientControl) {
                this.dataManager.sendToServer(this);
                set = this.ccscsFlag;
            }
            if (set) {
                this.markDirty();
                this.notifyListeners(value);
            } else {
                this.value = prev;
            }
        }
        return this.value;
    }

    public short get() {
        return this.value;
    }

    public ManagedShort setValidator(Function<Short, Short> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void validate() {
        if (this.validator != null) {
            this.value = this.validator.apply(this.value);
        }
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writeShort((int)this.value);
    }

    @Override
    public void fromBytes(MCDataInput input) {
        this.value = input.readShort();
        this.notifyListeners(this.value);
    }

    @Override
    public void toNBT(CompoundTag compound) {
        compound.m_128376_(this.name, this.value);
    }

    @Override
    public void fromNBT(CompoundTag compound) {
        this.value = compound.m_128448_(this.name);
        this.notifyListeners(this.value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getName() + "=" + this.value + "]";
    }

    public short add(short add) {
        return this.set((short)(this.get() + add));
    }

    public short subtract(short subtract) {
        return this.set((short)(this.get() - subtract));
    }

    public short multiply(short multiplyBy) {
        return this.set((short)(this.get() * multiplyBy));
    }

    public short divide(short divideBy) {
        return this.set((short)(this.get() / divideBy));
    }

    public short zero() {
        return this.set((short)0);
    }

    public short inc() {
        return this.add((short)1);
    }

    public short dec() {
        return this.subtract((short)1);
    }
}

