/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.handlers.contributor;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.brandonscore.handlers.contributor.ContributorConfig;
import com.brandon3055.brandonscore.handlers.contributor.ContributorFetcher;
import com.brandon3055.brandonscore.handlers.contributor.ContributorProperties;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class ContributorHandler {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");
    private static final Map<UUID, ContributorProperties> CONTRIBUTOR_MAP = new HashMap<UUID, ContributorProperties>();
    private static final ContributorFetcher FETCHER = new ContributorFetcher();
    private static final String PROJECT_KEY = "3055";
    private static long lastClientReload = 0L;

    public static void init() {
        LOCK.lock();
        FETCHER.init();
        MinecraftForge.EVENT_BUS.addListener(ContributorHandler::onClientTick);
        MinecraftForge.EVENT_BUS.addListener(ContributorHandler::onPlayerLogin);
    }

    public static void onClientLogin(Player player) {
        ContributorHandler.getPropsCallback(player, (ContributorProperties props) -> {
            BCoreNetwork.sendContributorConfigToServer(props);
            ContributorHandler.sendWelcomeMessage(player, props);
        });
    }

    private static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            CONTRIBUTOR_MAP.values().stream().filter(ContributorProperties::isContributor).filter(e -> !e.getUserID().equals(player2.m_20148_())).forEach(e -> BCoreNetwork.contributorConfigToClient(e).sendToPlayer(player2));
        }
    }

    private static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        CONTRIBUTOR_MAP.values().forEach(ContributorProperties::clientTick);
    }

    public static void getContributorStatus(UUID playerId, String username, Consumer<Map<String, String>> flagsCallback) {
        FETCHER.fetchContributorFlags(playerId, username, PROJECT_KEY, flagsCallback);
    }

    public static ContributorProperties getProps(UUID playerId, String username) {
        return CONTRIBUTOR_MAP.computeIfAbsent(playerId, uuid -> new ContributorProperties((UUID)uuid, username));
    }

    public static ContributorProperties getProps(Player player) {
        return ContributorHandler.getProps(player.m_20148_(), player.m_36316_().getName());
    }

    public static void getPropsCallback(Player player, Consumer<ContributorProperties> callBack) {
        ContributorHandler.getProps(player).onContributorLoaded(callBack);
    }

    public static void getPropsCallback(UUID playerID, Consumer<ContributorProperties> callBack) {
        ContributorHandler.getProps(playerID, null).onContributorLoaded(callBack);
    }

    public static void handleSettingsFromClient(ServerPlayer sender, PacketCustom packet) {
        ContributorConfig newConfig = ContributorConfig.deSerialize((MCDataInput)packet);
        ContributorHandler.getPropsCallback((Player)sender, (ContributorProperties props) -> {
            if (sender.f_8924_.m_6982_() || !sender.f_8924_.m_7779_(sender.m_36316_())) {
                props.setConfig(newConfig);
            }
            BCoreNetwork.sentToAllExcept(BCoreNetwork.contributorConfigToClient(props), (Player)sender);
        });
    }

    public static void handleSettingsFromServer(PacketCustom packet) {
        UUID uuid = packet.readUUID();
        ContributorConfig newConfig = ContributorConfig.deSerialize((MCDataInput)packet);
        if (!FETCHER.hasUser(uuid)) {
            ContributorHandler.reload();
        }
        ContributorHandler.getPropsCallback(uuid, (ContributorProperties e) -> e.setConfig(newConfig));
    }

    public static void linkUser(Player player, String linkCode, Consumer<Integer> callback) {
        FETCHER.linkUser(player, linkCode, errorCode -> {
            if (errorCode == -1) {
                ContributorHandler.linkSuccessful(player);
            }
            callback.accept((Integer)errorCode);
        });
    }

    public static void linkSuccessful(Player player) {
        BCoreNetwork.sendContribLinkToServer();
        ContributorHandler.reload();
        ContributorHandler.getPropsCallback(player, (ContributorProperties props) -> ContributorHandler.sendWelcomeMessage(player, props));
    }

    public static void handleClientLink(ServerPlayer sender) {
        if (sender.f_8924_.m_6982_() && !FETCHER.hasUser(sender.m_20148_()) && System.currentTimeMillis() - lastClientReload > 60000L) {
            ContributorHandler.reload();
            lastClientReload = System.currentTimeMillis();
        }
    }

    public static void reload() {
        FETCHER.reload();
        CONTRIBUTOR_MAP.clear();
    }

    private static void sendWelcomeMessage(Player player, ContributorProperties props) {
        if (!props.getConfig().showWelcome()) {
            return;
        }
        if (props.isDev()) {
            player.m_213846_((Component)Component.m_237113_((String)"DE Dev status confirmed.").m_130940_(ChatFormatting.AQUA));
            player.m_213846_((Component)Component.m_237113_((String)"All contributor features are available.").m_130940_(ChatFormatting.AQUA));
        } else if (props.isPatron()) {
            player.m_213846_((Component)Component.m_237113_((String)"Thank you for supporting Draconic Evolution!").m_130940_(ChatFormatting.AQUA));
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"Draconic Evolution contributor features enabled!").m_130940_(ChatFormatting.AQUA));
        }
        MutableComponent configCommand = Component.m_237113_((String)"/bcore_client contributor").m_130940_(ChatFormatting.BLUE);
        configCommand.m_6270_(configCommand.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/bcore_client contributor")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to run command"))));
        player.m_213846_((Component)Component.m_237113_((String)"Run ").m_7220_((Component)configCommand).m_7220_((Component)Component.m_237113_((String)" to access contributor settings.")));
        player.m_213846_((Component)Component.m_237113_((String)"You will also find an option to disable this message."));
    }

    public static boolean shouldCancelElytra(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ContributorProperties props = ContributorHandler.getProps(player);
            if (!props.hasWings()) {
                return false;
            }
            ContributorConfig config = props.getConfig();
            if (config.getWingsTier() == null && props.getAnim().hideDecay() == 1.0f) {
                return false;
            }
            return props.getConfig().getWingsElytra() == ContributorConfig.WingElytraCompat.HIDE_ELYTRA || props.getConfig().getWingsElytra() == ContributorConfig.WingElytraCompat.REPLACE;
        }
        return false;
    }
}

