/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.handlers.contributor;

import codechicken.lib.colour.Colour;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.handlers.FileHandler;
import com.brandon3055.brandonscore.handlers.contributor.ContributorProperties;
import com.google.gson.Gson;
import java.awt.Color;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.List;
import net.covers1624.quack.collection.FastStream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class ContributorConfig {
    private static final Gson GSON = new Gson();
    private boolean overrideShield = false;
    private int shieldOverride = 0;
    private boolean overrideBoneColour = false;
    private boolean overrideWebColour = false;
    private int boneColourOverride = 0;
    private int webColourOverride = 0;
    private boolean wingBoneShader = true;
    private boolean wingWebShader = true;
    private boolean wingBoneRGB = false;
    private boolean wingWebRGB = false;
    private boolean shieldRGB = false;
    private TechLevel wingsTier = TechLevel.CHAOTIC;
    private Badge chestBadge = null;
    private Badge backBadge = null;
    private WingBehavior wingsGround = WingBehavior.RETRACT;
    private WingBehavior wingsCreative = WingBehavior.RETRACT;
    private WingElytraCompat wingsElytra = WingElytraCompat.HIDE_ELYTRA;
    private boolean showWelcome = true;
    private transient boolean requiresSync = false;
    private transient TechLevel lastWingsTier = null;
    protected transient ContributorProperties props;
    private static float[][] TIER_COLOURS = new float[][]{{0.0f, 0.5f, 0.8f, 1.0f}, {0.55f, 0.0f, 0.65f, 1.0f}, {0.8f, 0.5f, 0.1f, 1.0f}, {0.75f, 0.05f, 0.05f, 1.0f}};

    public ContributorConfig() {
    }

    public ContributorConfig(ContributorProperties props) {
        this.props = props;
    }

    public boolean overrideShield() {
        return this.overrideShield && this.props.hasShieldRGB();
    }

    public void setOverrideShield(boolean overrideShield) {
        this.overrideShield = overrideShield;
        this.markDirty();
    }

    public int getShieldOverride() {
        return this.shieldOverride;
    }

    public void setShieldOverride(int shieldOverride) {
        this.shieldOverride = shieldOverride;
        this.markDirty();
    }

    public boolean getShieldRGB() {
        return this.shieldRGB && this.props.hasShieldRGB();
    }

    public void setShieldRGB(boolean shieldRGB) {
        this.shieldRGB = shieldRGB;
        this.markDirty();
    }

    @Nullable
    public TechLevel getWingsTier() {
        List<TechLevel> tiers = this.props.getWingTiers();
        return this.wingsTier == null || tiers.isEmpty() ? null : (tiers.contains((Object)this.wingsTier) ? this.wingsTier : tiers.get(tiers.size() - 1));
    }

    public TechLevel getWingRenderTier() {
        TechLevel tier = this.getWingsTier();
        return tier == null ? this.lastWingsTier : tier;
    }

    public void setWingsTier(@Nullable TechLevel wingsTier) {
        if (wingsTier == null) {
            this.lastWingsTier = this.wingsTier;
        }
        this.wingsTier = wingsTier;
        this.markDirty();
    }

    public boolean overrideWingBoneColour() {
        return this.overrideBoneColour && this.props.hasWingsRGB();
    }

    public void setOverrideWingBoneColour(boolean overrideBoneColour) {
        this.overrideBoneColour = overrideBoneColour;
        this.markDirty();
    }

    public int getWingsOverrideBoneColour() {
        return this.boneColourOverride;
    }

    public void setWingsOverrideBoneColour(int boneColourOverride) {
        this.boneColourOverride = boneColourOverride;
        this.markDirty();
    }

    public boolean getWingRGBBoneColour() {
        return this.wingBoneRGB && this.props.hasWingsRGB();
    }

    public void setWingRGBBoneColour(boolean wingBoneRGB) {
        this.wingBoneRGB = wingBoneRGB;
        this.markDirty();
    }

    public boolean getWingsBoneShader() {
        return this.wingBoneShader;
    }

    public void setWingsBoneShader(boolean wingShaderA) {
        this.wingBoneShader = wingShaderA;
        this.markDirty();
    }

    public boolean overrideWingWebColour() {
        return this.overrideWebColour && this.props.hasWingsRGB();
    }

    public void setOverrideWingsWebColour(boolean overrideWebColour) {
        this.overrideWebColour = overrideWebColour;
        this.markDirty();
    }

    public int getWingsOverrideWebColour() {
        return this.webColourOverride;
    }

    public void setWingsOverrideWebColour(int webColourOverride) {
        this.webColourOverride = webColourOverride;
        this.markDirty();
    }

    public boolean getWingRGBWebColour() {
        return this.wingWebRGB && this.props.hasWingsRGB();
    }

    public void setWingRGBWebColour(boolean wingWebRGB) {
        this.wingWebRGB = wingWebRGB;
        this.markDirty();
    }

    public boolean getWingsWebShader() {
        return this.wingWebShader;
    }

    public void setWingsWebShader(boolean wingWebShader) {
        this.wingWebShader = wingWebShader;
        this.markDirty();
    }

    public WingBehavior getWingsGround() {
        return this.wingsGround;
    }

    public void setWingsGround(WingBehavior wingsGround) {
        this.wingsGround = wingsGround;
        this.markDirty();
    }

    public WingBehavior getWingsCreative() {
        return this.wingsCreative;
    }

    public void setWingsCreative(WingBehavior wingsCreative) {
        this.wingsCreative = wingsCreative;
        this.markDirty();
    }

    public WingElytraCompat getWingsElytra() {
        return this.wingsElytra;
    }

    public void setWingsElytra(WingElytraCompat wingsElytra) {
        this.wingsElytra = wingsElytra;
        this.markDirty();
    }

    public Badge getChestBadge() {
        List<Badge> badges = this.props.getBadges();
        if (this.chestBadge == null && !badges.isEmpty()) {
            return badges.get(badges.size() - 1);
        }
        return badges.isEmpty() ? Badge.DISABLED : (badges.contains(this.chestBadge) ? this.chestBadge : badges.get(badges.size() - 1));
    }

    public void setChestBadge(@Nullable Badge chestBadge) {
        this.chestBadge = chestBadge;
        this.markDirty();
    }

    public Badge getBackBadge() {
        List<Badge> badges = this.props.getBadges();
        if (this.backBadge == null && !badges.isEmpty()) {
            return badges.get(badges.size() - 1);
        }
        return badges.isEmpty() ? Badge.DISABLED : (badges.contains(this.backBadge) ? this.backBadge : badges.get(badges.size() - 1));
    }

    public void setBackBadge(@Nullable Badge backBadge) {
        this.backBadge = backBadge;
        this.markDirty();
    }

    public boolean showWelcome() {
        return this.showWelcome;
    }

    public void setShowWelcome(boolean showWelcome) {
        this.showWelcome = showWelcome;
        this.markDirty();
    }

    public void markDirty() {
        this.requiresSync = true;
        this.save();
    }

    public boolean getResetSyncRequired() {
        if (this.requiresSync) {
            this.requiresSync = false;
            return true;
        }
        return false;
    }

    public static ContributorConfig load() {
        File file = new File(FileHandler.brandon3055Folder, "contributor_settings.json");
        if (file.exists()) {
            ContributorConfig contributorConfig;
            FileReader reader = new FileReader(file);
            try {
                ContributorConfig config = (ContributorConfig)GSON.fromJson((Reader)reader, ContributorConfig.class);
                config.requiresSync = true;
                contributorConfig = config;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            ((Reader)reader).close();
            return contributorConfig;
        }
        ContributorConfig config = new ContributorConfig();
        config.requiresSync = true;
        config.save();
        return config;
    }

    public void save() {
        File file = new File(FileHandler.brandon3055Folder, "contributor_settings.json");
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void serialize(MCDataOutput output) {
        output.writeBoolean(this.overrideShield);
        output.writeInt(this.shieldOverride);
        output.writeBoolean(this.wingsTier != null);
        if (this.wingsTier != null) {
            output.writeEnum((Enum)this.wingsTier);
            output.writeBoolean(this.overrideBoneColour);
            output.writeInt(this.boneColourOverride);
            output.writeBoolean(this.wingBoneShader);
            output.writeBoolean(this.overrideWebColour);
            output.writeInt(this.webColourOverride);
            output.writeBoolean(this.wingWebShader);
            output.writeBoolean(this.wingBoneRGB);
            output.writeBoolean(this.wingWebRGB);
            output.writeBoolean(this.shieldRGB);
            output.writeEnum((Enum)this.wingsGround);
            output.writeEnum((Enum)this.wingsCreative);
            output.writeEnum((Enum)this.wingsElytra);
        }
        output.writeBoolean(this.chestBadge != null);
        if (this.chestBadge != null) {
            output.writeEnum((Enum)this.chestBadge);
        }
        output.writeBoolean(this.backBadge != null);
        if (this.backBadge != null) {
            output.writeEnum((Enum)this.backBadge);
        }
        output.writeBoolean(this.showWelcome);
    }

    public static ContributorConfig deSerialize(MCDataInput input) {
        boolean bbe;
        boolean cbe;
        ContributorConfig config = new ContributorConfig();
        config.overrideShield = input.readBoolean();
        config.shieldOverride = input.readInt();
        boolean enabled = input.readBoolean();
        if (enabled) {
            config.wingsTier = (TechLevel)input.readEnum(TechLevel.class);
            config.overrideBoneColour = input.readBoolean();
            config.boneColourOverride = input.readInt();
            config.wingBoneShader = input.readBoolean();
            config.overrideWebColour = input.readBoolean();
            config.webColourOverride = input.readInt();
            config.wingWebShader = input.readBoolean();
            config.wingBoneRGB = input.readBoolean();
            config.wingWebRGB = input.readBoolean();
            config.shieldRGB = input.readBoolean();
            config.wingsGround = (WingBehavior)input.readEnum(WingBehavior.class);
            config.wingsCreative = (WingBehavior)input.readEnum(WingBehavior.class);
            config.wingsElytra = (WingElytraCompat)input.readEnum(WingElytraCompat.class);
        }
        if (cbe = input.readBoolean()) {
            config.chestBadge = (Badge)input.readEnum(Badge.class);
        }
        if (bbe = input.readBoolean()) {
            config.backBadge = (Badge)input.readEnum(Badge.class);
        }
        config.showWelcome = input.readBoolean();
        return config;
    }

    public int getBaseColourI(TechLevel techLevel) {
        if (techLevel == null) {
            techLevel = TechLevel.DRACONIUM;
        }
        return Colour.packARGB((float[])TIER_COLOURS[techLevel.index]);
    }

    public float[] getWingBoneColour(float partialTick) {
        return ContributorConfig.getColour(this.getWingRenderTier(), this.overrideWingBoneColour(), this.getWingsOverrideBoneColour(), this.getWingRGBBoneColour(), this.props.getAnim().getWingBoneCol(partialTick));
    }

    public float[] getWingWebColour(float partialTick) {
        return ContributorConfig.getColour(this.getWingRenderTier(), this.overrideWingWebColour(), this.getWingsOverrideWebColour(), this.getWingRGBWebColour(), this.props.getAnim().getWingWebCol(partialTick));
    }

    public int getShieldColour(float partialTick) {
        if (this.getShieldRGB()) {
            float[] colours = ContributorConfig.unpack(this.getShieldOverride());
            return Color.HSBtoRGB(this.props.getAnim().getShieldCol(partialTick), colours[1], colours[2]);
        }
        return this.getShieldOverride();
    }

    private static float[] getColour(TechLevel level, boolean useOverride, int override, boolean rgbEffect, float anim) {
        if (useOverride) {
            float[] colours = ContributorConfig.unpack(override);
            if (rgbEffect) {
                colours = ContributorConfig.unpack(Color.HSBtoRGB(anim, colours[1], colours[2]));
            }
            return colours;
        }
        return level == null ? TIER_COLOURS[0] : TIER_COLOURS[level.index];
    }

    public static float[] unpack(int colour) {
        return new float[]{(float)(colour >> 16 & 0xFF) / 255.0f, (float)(colour >> 8 & 0xFF) / 255.0f, (float)(colour & 0xFF) / 255.0f, 1.0f};
    }

    public static enum Badge implements HoverText
    {
        DISABLED("Disabled", ""),
        PATREON_OG("OG Patreon", "The original patreon badge"),
        PATREON_DRACONIUM("Draconium", "Draconium Patreon Badge"),
        PATREON_WYVERN("Wyvern", "Wyvern Patreon Badge"),
        PATREON_DRACONIC("Draconic", "Draconic Patreon Badge"),
        PATREON_CHAOTIC("Chaotic", "Chaotic Patreon Badge"),
        OG_VETERAN("OG Veteran", "This badge is only given to long term supporters", "who joined before the Patreon overhaul in December 2022.", "This is a permanent badge."),
        LOLNET("Lolnet", "Legacy Lolnet Badge"),
        CR("CR", "Creation Reborn");

        private final String name;
        private final List<Component> hover;

        private Badge(String name, String ... hover) {
            this.name = name;
            this.hover = FastStream.of((Object[])hover).map(e -> Component.m_237113_((String)e)).toList();
        }

        @Override
        public List<Component> getHoverText() {
            return this.hover;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum WingBehavior implements HoverText
    {
        HIDE("Hide", ""),
        RETRACT("Retract", ""),
        EXTEND("Extend", ""),
        EXTEND_AND_FLAP("Extend and flap", "");

        private final String name;
        private final List<Component> hover;

        private WingBehavior(String name, String ... hover) {
            this.name = name;
            this.hover = FastStream.of((Object[])hover).map(e -> Component.m_237113_((String)e)).toList();
        }

        @Override
        public List<Component> getHoverText() {
            return this.hover;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum WingElytraCompat implements HoverText
    {
        HIDE_WINGS("Hide wings", "Wings will be hidden while wearing Elytra."),
        HIDE_ELYTRA("Hide Elytra", "The Elytra model will be disabled in favour of the wings."),
        SHOW_BOTH("Show Both", "Both the wings and Elytra will render on top of each other.", "Not sure why you would want this but its an option."),
        REPLACE("Elytra Only", "The wings will replace the Elytra model.", "And " + ChatFormatting.RED + "they will only be visible while wearing Elytra.");

        private final String name;
        private final List<Component> hover;

        private WingElytraCompat(String name, String ... hover) {
            this.name = name;
            this.hover = FastStream.of((Object[])hover).map(e -> Component.m_237113_((String)e)).toList();
        }

        @Override
        public List<Component> getHoverText() {
            return this.hover;
        }

        public String toString() {
            return this.name;
        }
    }

    public static interface HoverText {
        public List<Component> getHoverText();
    }
}

