/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.particle;

import com.brandon3055.brandonscore.utils.DataUtils;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;

public class IntParticleType
extends ParticleType<IntParticleData> {
    private static ParticleOptions.Deserializer<IntParticleData> DESERIALIZER = new ParticleOptions.Deserializer<IntParticleData>(){

        public IntParticleData fromCommand(ParticleType<IntParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            ArrayList<Integer> list = new ArrayList<Integer>();
            while (reader.peek() == ' ') {
                reader.expect(' ');
                list.add(reader.readInt());
            }
            return new IntParticleData(particleTypeIn, DataUtils.toPrimitive(list.toArray(new Integer[0])));
        }

        public IntParticleData fromNetwork(ParticleType<IntParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            return new IntParticleData(particleTypeIn, buffer.readByte());
        }
    };

    public IntParticleType(boolean alwaysShow) {
        super(alwaysShow, DESERIALIZER);
    }

    public Codec<IntParticleData> m_7652_() {
        return null;
    }

    public static class IntParticleData
    implements ParticleOptions {
        private ParticleType<?> type;
        private int[] data;

        public IntParticleData(ParticleType<?> type, int ... data) {
            this.type = type;
            this.data = data;
        }

        public ParticleType<?> m_6012_() {
            return this.type;
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.m_130089_(this.data);
        }

        public int[] get() {
            return this.data;
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %sb", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), DataUtils.stringArrayConcat(DataUtils.arrayToString(this.data), " "));
        }
    }
}

